package com.cab.service;

import com.cab.dao.ContentTypeMapper;
import com.cab.model.ContentType;
import com.cab.model.TreeDemo;
import com.cku.upyun.ImageFtp;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by user on 2016/5/16.
 */
@Service("contentTypeService")
public class ContentTypeServiceImpl {
    @Autowired
    private ContentTypeMapper contentTypeMapper;

    public List<TreeDemo> selectAll(){
        List<TreeDemo> resultList = new ArrayList<TreeDemo>();
        List<TreeDemo> tree2List = new ArrayList<TreeDemo>();
        List<TreeDemo> tree3List = new ArrayList<TreeDemo>();

        List<ContentType> list = contentTypeMapper.selectAll();
        for(ContentType ct1 : list){
            if(ct1.getLevel()==1){
                resultList.add(new TreeDemo(ct1.getId(),ct1.getParentTypeId(),ct1.getLevel(),ct1.getName(),new ArrayList<TreeDemo>()));
            }
            if(ct1.getLevel()==2){
                tree2List.add(new TreeDemo(ct1.getId(),ct1.getParentTypeId(),ct1.getLevel(),ct1.getName(),new ArrayList<TreeDemo>()));
            }
            if(ct1.getLevel()==3){
                tree3List.add(new TreeDemo(ct1.getId(),ct1.getParentTypeId(),ct1.getLevel(),ct1.getName(),null));
            }
        }
        for(TreeDemo td : tree2List){
            buildNodes(td,tree3List);
        }
        for(TreeDemo td : resultList){
            buildNodes(td,tree2List);
        }
        return resultList;
    }
    public ContentType getDetail(String id){
        return contentTypeMapper.selectByPrimaryKey(id);
    }
    @Transactional
    public int delDetail(String id){
        List<String> parentList = new ArrayList<String>();
        parentList.add(id);
        List<ContentType> list = contentTypeMapper.selectByParentIdList(parentList);
        if(list!=null && list.size()>0){
            for(ContentType ct : list){
            	String thumb = ct.getImgUrl();
            	if(thumb!=null && !"".equals(thumb) && thumb.length()>ImageFtp.UPYUNWEBURL.length() &&thumb.startsWith(ImageFtp.UPYUNWEBURL)){
            		ImageFtp.deleteFile(thumb.replace(ImageFtp.UPYUNWEBURL, ""));
            	}
                contentTypeMapper.deleteByPrimaryKey(ct.getId());
            }
        }
        ContentType ctp = contentTypeMapper.selectByPrimaryKey(id);
        String thumbp = ctp.getImgUrl();
    	if(thumbp!=null && !"".equals(thumbp) && thumbp.length()>ImageFtp.UPYUNWEBURL.length() &&thumbp.startsWith(ImageFtp.UPYUNWEBURL)){
    		ImageFtp.deleteFile(thumbp.replace(ImageFtp.UPYUNWEBURL, ""));
    	}
        return contentTypeMapper.deleteByPrimaryKey(id);
    }
    public int updateDetail(String detailId,String detailName,String detailImgUrl){
        ContentType ct = contentTypeMapper.selectByPrimaryKey(detailId);
       	String thumb = ct.getImgUrl();
    	if(thumb!=null && !"".equals(thumb) && thumb.length()>ImageFtp.UPYUNWEBURL.length() &&thumb.startsWith(ImageFtp.UPYUNWEBURL)){
    		ImageFtp.deleteFile(thumb.replace(ImageFtp.UPYUNWEBURL, ""));
    	}
        ct.setImgUrl(detailImgUrl);
        ct.setName(detailName);
        return contentTypeMapper.updateByPrimaryKeySelective(ct);
    }
    public int saveDetail(String addDetailId,String addDetailName,String addDetailImgUrl,Integer addDetailLevel,String addDetailParentId){
        ContentType ct = null;
        ct = contentTypeMapper.selectByPrimaryKey(addDetailId);
        if(ct!=null){
            return -2;
        }else{
            ct = new ContentType();
            ct.setName(addDetailName);
            ct.setId(addDetailId);
            ct.setImgUrl(addDetailImgUrl);
            ct.setLevel(addDetailLevel);
            ct.setParentTypeId(addDetailParentId);
            if(addDetailLevel==3){
                ct.setCanInto(0);
            }else{
                ct.setCanInto(1);
            }
            return contentTypeMapper.insertSelective(ct);
        }

    }
    public void buildNodes(TreeDemo td ,List<TreeDemo> list){
        for(TreeDemo tdchi :list){
            if(td.getId().equals(tdchi.getParentId())){
                td.getNodes().add(tdchi);
            }
        }

    }
}
