package com.cku.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cku.core.BaseDAOMapper;
import com.cku.core.BaseService;
import com.cku.core.ExecResultModel;
import com.cku.core.PageBeanResult;
import com.cku.dao.CkuMatchRuleMapper;
import com.cku.model.CkuMatchRule;
import com.cku.util.PageBean;

@Service("ckuMatchRuleService")
public class CkuMatchRuleServiceImpl  extends BaseService<CkuMatchRule>{
	@Autowired
	public CkuMatchRuleMapper ckuMatchRuleMapper;
	@Override
	protected BaseDAOMapper<CkuMatchRule> getDAO() {
		return this.ckuMatchRuleMapper;
	}
	public String getAll(){
		ExecResultModel<CkuMatchRule> resultModel = new ExecResultModel<CkuMatchRule>();
		List<CkuMatchRule> list =ckuMatchRuleMapper.getAll();
		resultModel.setItems(list);
		resultModel.setTotal((long) list.size());
		resultModel.setRc(0);
		return resultModel.getToJson();
	}
	
	public String getRuleById(Long id){
		ExecResultModel<CkuMatchRule> resultModel = new ExecResultModel<CkuMatchRule>();
		List<CkuMatchRule> list =new ArrayList<CkuMatchRule>();
		CkuMatchRule ckuMatchRule = ckuMatchRuleMapper.selectByPrimaryKey(id);
		list.add(ckuMatchRule);
		resultModel.setItems(list);
		resultModel.setTotal((long) list.size());
		resultModel.setRc(0);
		return resultModel.getToJson();
	}
	public PageBeanResult<CkuMatchRule> getList(String ruleName,String ruleInfo, PageBean pb) {
		PageBeanResult<CkuMatchRule> pbr = new PageBeanResult<CkuMatchRule>();
		List<CkuMatchRule> list = ckuMatchRuleMapper.getList(ruleName,ruleInfo,pb.get_limit(),pb.get_start());
		pbr.list = list;
		if (pb.getNeedCount()){
			pbr.totalCount = ckuMatchRuleMapper.getCount(ruleName,ruleInfo);
		}
		return pbr;
	}

}
