package com.cku.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cku.core.ExecResultModel;
import com.cku.dao.CkuDogClassMapper;
import com.cku.model.CkuDogClass;
/**
 * 查询犬种的信息
 * @author gates
 *
 */
@Service("ckuDogClassService")
public class CkuDogClassServiceImpl {

	@Autowired
	public CkuDogClassMapper ckuDogClassMapper;
	
	public String getDogClass(String name,String hot){
		ExecResultModel<CkuDogClass> resultModel = new ExecResultModel<CkuDogClass>();
		List<CkuDogClass> list = ckuDogClassMapper.getDogClass(name,hot);
		for (int i = 0; i < list.size(); i++) {
			if(list.get(i).getDogChinaName()!=null){
				list.get(i).setDogChinaName(list.get(i).getDogChinaName().trim());
			}
		}
		resultModel.setItems(list);
		resultModel.setRc(0);
		resultModel.setMsg("返回正常结果");
		resultModel.setTotal((long)list.size());
		return resultModel.getToJson();
	}
}
