/*
 * Decompiled with CFR 0.152.
 */
package com.cku.patchca.background;

import com.cku.patchca.background.BackgroundFactory;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class GradientBackgroundFactory
implements BackgroundFactory {
    private Color startColor;
    private Color endColor;
    private Direction direction;

    public GradientBackgroundFactory() {
        this(new Color(192, 192, 0), new Color(192, 128, 128), Direction.Horizontal);
    }

    public GradientBackgroundFactory(Color startColor, Color endColor, Direction direction) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.direction = direction;
    }

    public void fillBackground(BufferedImage dest) {
        float y2;
        float x2;
        float y1;
        float x1;
        switch (this.direction) {
            default: {
                x1 = 0.0f;
                y1 = 0.0f;
                x2 = dest.getWidth();
                y2 = 0.0f;
                break;
            }
            case Vertical: {
                x1 = 0.0f;
                y1 = 0.0f;
                x2 = 0.0f;
                y2 = dest.getHeight();
                break;
            }
            case BottomLeftTopRight: {
                x1 = 0.0f;
                y1 = dest.getHeight();
                x2 = dest.getWidth();
                y2 = 0.0f;
                break;
            }
            case TopLeftBottomRight: {
                x1 = 0.0f;
                y1 = 0.0f;
                x2 = dest.getWidth();
                y2 = dest.getHeight();
            }
        }
        GradientPaint gp = new GradientPaint(x1, y1, this.startColor, x2, y2, this.endColor);
        Graphics2D g = dest.createGraphics();
        g.setPaint(gp);
        g.fillRect(0, 0, dest.getWidth(), dest.getHeight());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        Horizontal,
        Vertical,
        TopLeftBottomRight,
        BottomLeftTopRight;

    }
}

