package com.sys.service;

import com.sys.dao.Oauth2UserMapper;
import com.sys.model.Oauth2User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.Date;

/**
 * Created with IntelliJ IDEA.
 * User: lyy
 * Date: 2016/8/5
 * Time: 10:01
 */
@Service("oauth2UserService")
public class Oauth2UserServiceImpl {
    @Autowired
    private Oauth2UserMapper oauth2UserMapper;

    public Oauth2User login (String username, String password){
        return oauth2UserMapper.login(username,password);
    }
    public int addAuthCode(Long id,String oauthCode){
        Oauth2User oauth2User = new Oauth2User();
        oauth2User.setId(id);
        oauth2User.setOauthCode(oauthCode);
        oauth2User.setOauthCodeTime(new Date());
        return oauth2UserMapper.updateByPrimaryKeySelective(oauth2User);
    };
    public int addAccessToken(Long id,String accessToken){
        Oauth2User oauth2User = new Oauth2User();
        oauth2User.setId(id);
        oauth2User.setAccessToken(accessToken);
        oauth2User.setAccessTokenTime(new Date());
        return oauth2UserMapper.updateByPrimaryKeySelective(oauth2User);
    }
}
