package com.cku.service;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.cku.core.BaseDAOMapper;
import com.cku.core.BaseService;
import com.cku.core.ExecResultModel;
import com.cku.core.PageBeanResult;
import com.cku.dao.CkuImageMapper;
import com.cku.dao.CkuMatchHotelMapper;
import com.cku.model.CkuImage;
import com.cku.model.CkuMatchHotel;
import com.cku.util.HttpClientUtil;
import com.cku.util.HttpResult;
import com.cku.util.PageBean;
import com.cku.util.SysConfig;

@Service("ckuMatchHotelService")
public class CkuMatchHotelServiceImpl  extends BaseService<CkuMatchHotel>{
	@Autowired
	public CkuMatchHotelMapper ckuMatchHotelMapper;
	@Autowired 
	public CkuImageMapper ckuImageMapper;
	@Override
	protected BaseDAOMapper<CkuMatchHotel> getDAO() {
		return this.ckuMatchHotelMapper;
	}
	public String getHotel(String showLocation){
		ExecResultModel<CkuMatchHotel> resultModel = new ExecResultModel<CkuMatchHotel>();
		List<CkuMatchHotel> list =ckuMatchHotelMapper.getHotel(showLocation);
		resultModel.setItems(list);
		resultModel.setTotal((long) list.size());
		resultModel.setRc(0);
		resultModel.setMsg("");
		return resultModel.getToJson();
	}
	
	public PageBeanResult<CkuMatchHotel> getList(String name,String address,PageBean pb){
		PageBeanResult<CkuMatchHotel> pbr = new PageBeanResult<CkuMatchHotel>();
		List<CkuMatchHotel> list = ckuMatchHotelMapper.getList(name,address,pb.get_limit(),pb.get_start());
		pbr.list = list;
		pbr.totalCount = ckuMatchHotelMapper.getCount(name,address);
		return pbr;
	}
	public int addMatchHotel(CkuMatchHotel ckuMatchHotel) throws IOException {
		Map<String, String> map = new HashMap<String, String>();
		map.put("address", ckuMatchHotel.getHotelAddress().replaceAll(" ", ""));
		map.put("output", "json");
		map.put("ak", SysConfig.getInstance().getProperty("ak"));
		HttpResult httpResult = HttpClientUtil.get(null, SysConfig.getInstance().getProperty("baidulatlngurl"), map);
		String repb = httpResult.getResponseBody();
		JSONObject obj = JSONObject.parseObject(repb);
		if(obj.getInteger("status").intValue()==0){
			String lng = obj.getJSONObject("result").getJSONObject("location").getString("lng");
			String lat = obj.getJSONObject("result").getJSONObject("location").getString("lat");
			ckuMatchHotel.setHotelLatitude(lat);
			ckuMatchHotel.setHotelLongitude(lng);
		}
		ckuMatchHotel.setCreateTime(new Date());
		return ckuMatchHotelMapper.insertSelective(ckuMatchHotel);
	}
	public int updateMatchHotel(CkuMatchHotel ckuMatchHotel) throws IOException {
		Map<String, String> map = new HashMap<String, String>();
		map.put("address", ckuMatchHotel.getHotelAddress().replaceAll(" ", ""));
		map.put("output", "json");
		map.put("ak", SysConfig.getInstance().getProperty("ak"));
		HttpResult httpResult = HttpClientUtil.get(null, SysConfig.getInstance().getProperty("baidulatlngurl"), map);
		String repb = httpResult.getResponseBody();
		JSONObject obj = JSONObject.parseObject(repb);
		if(obj.getInteger("status").intValue()==0){
			String lng = obj.getJSONObject("result").getJSONObject("location").getString("lng");
			String lat = obj.getJSONObject("result").getJSONObject("location").getString("lat");
			ckuMatchHotel.setHotelLatitude(lat);
			ckuMatchHotel.setHotelLongitude(lng);
		}
		ckuMatchHotel.setCreateTime(new Date());
		return ckuMatchHotelMapper.updateByPrimaryKeySelective(ckuMatchHotel);
	}
	//根据酒店的id 查询有图片否
	public List<CkuImage> getImageById(long id) {
		List<CkuImage> list=ckuImageMapper.getImageById(id);
		return list;
	}
	public CkuMatchHotel selectById(long id) {
		CkuMatchHotel cmh=ckuMatchHotelMapper.selectById(id);
		return cmh;
		
	}
	
}
