package com.cab.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cab.model.Content;

public interface ContentMapper {
    List<Content> selectByContentType(String contentTypeId, long start, long count);
    long selectCountByContentType(String contentTypeId);

    Content selectByPrimaryKey(Long id);
    
    int insertSelective(Content content);

    int increaseCommentCount(long contentId);

    int increaseUpCount(long contentId);
    int increaseFavCount(long contentId);
    int decreaseUpCount(long contentId);
    int decreaseFavCount(long contentId);
    
    
    
    
    
    List<Content> getByContentType(@Param("contentTypeParentId")String contentTypeParentId,@Param("contentTypeId")String contentTypeId, @Param("title")String title, @Param("start")long start, @Param("count")long count);
    long getByContentTypeCount(@Param("contentTypeParentId")String contentTypeParentId,@Param("contentTypeId")String contentTypeId,@Param("title")String title);
    //分页得到推荐消息
    List<Content> getAllIsTop(@Param("page")long page, @Param("limit")long limit);
    List<Content> getIsFirst(String paramsType);
    Content getContentInfoById(Long id);
    
    List<Content> getContentPage(@Param("contentType1")String contentType1,@Param("contentType2")String contentType2,
    		@Param("contentType3")String contentType3,@Param("title")String title,@Param("isFirst")String isFirst,
    		@Param("isTop")String isTop,@Param("isCreate")String isCreate,@Param("page")Long page,@Param("limit")Long limit);
    long getContentPageCount(@Param("contentType1")String contentType1,@Param("contentType2")String contentType2,
    		@Param("contentType3")String contentType3,@Param("title")String title,@Param("isFirst")String isFirst,
    		@Param("isTop")String isTop,@Param("isCreate")String isCreate);
    List<Content> searchFavorite(@Param("userId") String userId,@Param("title") String title,@Param("start")Long start,@Param("limit")Long limit);
    long searchFavoriteCount(@Param("userId") String userId,@Param("title") String title);
    int changeIsTop(@Param("id")Integer id,@Param("isVal")Integer isVal);
    int changeIsFirst(@Param("id")Integer id,@Param("isVal")Integer isVal);

    int updateTime(@Param("id")Long id,@Param("time")String time);
    int del(@Param("id")Integer id);
	int update(Content ctm);
	//得到推荐消息数
	Long getAllIsTopCount();
}