<%@ page language="java" contentType="text/html;charset=UTF-8" %> 
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap/css/bootstrap.min.css">
	<link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap/css/bootstrap-theme.min.css">
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/bootstrap/js/bootstrap.min.js"></script>
	<script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/jquery.twbsPagination/jquery.twbsPagination.js"></script>
</head>
<body>
<div class="container-fluid">
			<div class="input-group">
			  <span class="input-group-addon">名称</span>
			  <input type="text" class="form-control" id="keyword" placeholder="名称" aria-describedby="basic-addon1">
			  <span class="input-group-addon" onclick="resend()">发送</span>
			</div>
			    <table class="table">
			      <thead>
			        <tr>
			          <th>ID</th>
			          <th>名称</th>
			          <th>类别</th>
			          <th>操作</th>
			        </tr>
			      </thead>
			      <tbody id="showcontent">
			      </tbody>
			    </table>
			    <nav id="pagination_box"><ul class="pagination" id="pagercontent"></ul></nav>
			  	<span id="pageval" style="display:none;">1</span>
			  	<span id="pagetotal" style="display:none;">0</span>

</div>
<script>
	send();
	//重新发送请求
	function resend(){
		$("#pageval").html(1);
		send();
	}
	//发送请求
	function send(){
		var keyword = $("#keyword").val();
		var page = $("#pageval").html();
		$.ajax({
			type:"get",
			url:"<%=request.getContextPath() %>/ckuCaiPan/getListModal.do",
			data:{name:keyword,page:page,limit:10},
 			dataType: 'json',
	        timeout: 30000,
	        success: function(json){
	    		if(json.rc==0){
	    			var list = json.items;
	    			console.log(list);
	    			if(list.length>0){
	    				var html = "";
	    				$.each(list, function(index,item) {
	    					html+="<tr><td>"+item.id+"</td><td>"+item.ckuTitle+"</td><td>"+item.ckuPosition+"</td><td>"+
	    					"<button type=\"button\" onclick=\"addParent("+item.id+")\" class=\"btn btn-default\">选择</button></td></tr>";
	    				});
	    				$("#showcontent").html(html);
	    			}else{
	    				$("#showcontent").html("没有数据");
	    			}
	    			//分页代码
	    			var page_size = $("#pagetotal").html();
	    			page_size = parseInt(page_size);
    				if(page_size!=json.total){
    				     $("#pagination_box").html('<ul id="pagercontent" class="pagination"></ul>');
    				}
    				$('#pagercontent').twbsPagination({
    					  startPage: page,
    					  initiateStartPageClick: false,
    					  totalPages: json.total==0?1:Math.ceil(json.total/10),
    					  onPageClick: function (event, page) {
    					    $('#pageval').html(page);
    					    send();
    					  }
    					});
    				$("#pagetotal").html(json.total);
    				
    				
	    		}else{
	    			$("#showcontent").html("请求出错！");
	    		}
	        },
	        error: function(xhr, type){
	            
	        }
		});
	}
	function addParent(hotelId){
		console.log(parent);
		  parent.$('#addDetailId').val(hotelId);
		  parent.layer.closeAll();
	}
</script>
</body>
</html>
