package com.sys.controller;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cab.service.UserService;
import com.cku.core.RESTResponse;
import com.cku.util.ServletUtils;
import com.cku.util.SysConfig;
import com.sys.service.AlipayServiceImpl;

@Controller
@RequestMapping(value="alipay")
public class AlipayController {
	private static Logger logger = Logger.getLogger(AlipayController.class);
	@Autowired
	AlipayServiceImpl alipayService;
	
	/**
	 * 
	 * @Description：获取配置文件中的sign回传给app
	 * @author: 
	 * @version: 2016年9月13日 下午7:25:49
	 */
	@RequestMapping(value = "/getSign")
	public void getSign(HttpServletResponse response,HttpServletRequest request) throws IOException
	{
		RESTResponse result = null;
		try
		{
			String sign = SysConfig.getInstance().getProperty("apliaykey");
			result = new RESTResponse("sign", sign);
		}
		catch (Exception e)
		{
			result = new RESTResponse(e);
		}
		
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 
	 * @Description：生成订单
	 * @author: 
	 * @version: 2016年9月13日 下午7:26:17
	 */
	@RequestMapping(value = "/getOrder")
	public void getOrder(HttpServletResponse response,HttpServletRequest request) throws IOException
	{
		RESTResponse result = null;
		try
		{
			String userId =UserService.verifyThirdUserId(request);
			Date date=new Date();
			DateFormat df=new SimpleDateFormat("yyyyMMddHHmmss");
			boolean flag = alipayService.getOrder(userId);
			if(flag){
				result = new RESTResponse("order",df.format(date)+userId);
			}else{
				result = new RESTResponse(-1,"您没有CKU的身份！");
			}

			
		}
		catch (Exception e)
		{
			result = new RESTResponse(e);
		}
		
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 
	 * @Description：更改账户余额
	 * @author: 
	 * @version: 2016年9月13日 下午7:30:34
	 */
	@RequestMapping(value = "/waitAlipayMessage")
	public void waitAlipayMessage(HttpServletResponse response,HttpServletRequest request)
	{
		// ServletUtils.isHttps(r)
		RESTResponse result = null;
		try {
			//http://notify.java.jpxx.org/index.jsp?
			//discount=0.00&payment_type=1&subject=测试&trade_no=2013082244524842&
			//buyer_email=dlwdgl@gmail.com&gmt_create=2013-08-22 14:45:23&notify_type=trade_status_sync&
			//quantity=1&out_trade_no=082215222612710&seller_id=2088501624816263&notify_time=2013-08-22 14:45:24&
			//body=测试测试&trade_status=TRADE_SUCCESS&is_total_fee_adjust=N&total_fee=1.00&
			//gmt_payment=2013-08-22 14:45:24&seller_email=xxx@alipay.com&price=1.00&
			//buyer_id=2088602315385429&notify_id=64ce1b6ab92d00ede0ee56ade98fdf2f4c&use_coupon=N&
			//sign_type=RSA&sign=1glihU9DPWee+UJ82u3+mw3Bdnr9u01at0M/xJnPsGuHh+JA5bk3zbWaoWhU6GmLab3dIM4JNdktTcEUI9/FBGhgfLO39BKX/eBCFQ3bXAmIZn4l26fiwoO613BptT44GTEtnPiQ6+tnLsGlVSrFZaLB9FVhrGfipH2SWJcnwYs=
			String discount = ServletUtils.getParameter(request, "discount");//折扣
			Integer payment_type = ServletUtils.getParameterInt(request,"payment_type", 1);//支付类型
			String subject = ServletUtils.getParameter(request, "subject");//商品名称
			String trade_no = ServletUtils.getParameter(request, "trade_no");//支付宝交易号
			String buyer_email = ServletUtils.getParameter(request,"buyer_email");//买家支付宝账号
			String gmt_create = ServletUtils.getParameter(request, "gmt_create");//交易创建时间
			String notify_type = ServletUtils.getParameter(request,"notify_type");//通知类型
			String quantity = ServletUtils.getParameter(request, "quantity");//购买数量
			String out_trade_no = ServletUtils.getParameter(request,"out_trade_no");//商户网站唯一订单号
			String seller_id = ServletUtils.getParameter(request, "seller_id");//卖家支付宝用户号
			String notify_time = ServletUtils.getParameter(request,"notify_time");//通知时间
			String body = ServletUtils.getParameter(request, "body",null);//商品描述
			String trade_status = ServletUtils.getParameter(request,"trade_status");//交易状态
			String is_total_fee_adjust = ServletUtils.getParameter(request,"is_total_fee_adjust");//是否调整总价
			String total_fee = ServletUtils.getParameter(request, "total_fee");//交易金额
			String gmt_payment = ServletUtils.getParameter(request,"gmt_payment");//交易付款时间
			String seller_email = ServletUtils.getParameter(request,"seller_email");//卖家支付宝账号
			String price = ServletUtils.getParameter(request, "price");//商品单价
			String buyer_id = ServletUtils.getParameter(request, "buyer_id");//买家支付宝用户号
			String notify_id = ServletUtils.getParameter(request, "notify_id");//通知校验ID
			String sign_type = ServletUtils.getParameter(request, "sign_type");//签名方式
			String sign = ServletUtils.getParameter(request, "sign");//签名
			logger.info("alipay=subject========================"+subject);
			logger.info("alipay=body========================"+body);
			logger.info("alipay=price========================"+price);
			logger.info("alipay=buyer_id========================"+buyer_id);
			logger.info("alipay=trade_no========================"+trade_no);
			logger.info("alipay=buyer_email========================"+buyer_email);
			logger.info("alipay=out_trade_no========================"+out_trade_no);
			logger.info("alipay=trade_status========================"+trade_status);
			logger.info("alipay=total_fee========================"+total_fee);
			if("TRADE_SUCCESS".equals(trade_status)){
				alipayService.rechargeBanlance(out_trade_no.substring(14, out_trade_no.length()),out_trade_no,total_fee);
			}
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			response.getWriter().write("success");
		} catch (Exception e) {
			logger.error(e);
		}
	}
}
