package com.cab.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cab.dao.CabAddressMapper;
import com.cab.model.CabAddress;
import com.cku.core.ExecResultModel;
import com.sys.dao.AreaMapper;
import com.sys.dao.CityMapper;
import com.sys.dao.ProvinceMapper;

@Service("userAddressService")
public class UserAddressServiceImpl  {
	@Autowired
	public CabAddressMapper cabAddressMapper;
	
	@Autowired
	public ProvinceMapper provinceMapper;
	
	@Autowired
	public CityMapper cityMapper;
	
	@Autowired
	public AreaMapper areaMapper;
	/**
	 * 
	 * @Description：获取用户地址列表
	 * @author: zhuoHeng
	 * @version: 2016年4月5日 下午4:33:21
	 */
	public String getUserAddress(String userId){
		ExecResultModel<CabAddress> resultModel = new ExecResultModel<CabAddress>();
		List<CabAddress> eventIntroduce = cabAddressMapper.getUserAddress(userId);
		for (int i = 0; i < eventIntroduce.size(); i++) {
			String provinceName =  provinceMapper.getProvince(eventIntroduce.get(i).getProvince());
			String cityName = "";
			if(!"".equals(eventIntroduce.get(i).getCity())&&eventIntroduce.get(i).getCity()!=null){
				cityName = cityMapper.getCity(eventIntroduce.get(i).getCity());
			}
			String areaName = "";
			if(!"".equals(eventIntroduce.get(i).getArea())&&eventIntroduce.get(i).getArea()!=null){
				areaName = areaMapper.getArea(eventIntroduce.get(i).getArea());
			}
			if(provinceName==null){
				eventIntroduce.get(i).setRessStr("");
			}else if(cityName==null){
				eventIntroduce.get(i).setRessStr(provinceName);
			}else if(areaName==null){
				eventIntroduce.get(i).setRessStr(provinceName+" "+cityName);
			}else{
				eventIntroduce.get(i).setRessStr(provinceName+" "+cityName+" "+areaName);
			}
			eventIntroduce.get(i).setProvince(null);
			eventIntroduce.get(i).setCity(null);
			eventIntroduce.get(i).setArea(null);
		}
		resultModel.setItems(eventIntroduce);
		resultModel.setRc(0);
		resultModel.setMsg("");
		resultModel.setTotal((long)eventIntroduce.size());
		return resultModel.getToJson(); 
	}
	/**
	 * 
	 * @Description：删除我的常用地址
	 * @author: zhuoHeng
	 * @version: 2016年4月5日 下午6:10:32
	 */
	public String deleteUserAddress(String id,String userId){
		ExecResultModel<CabAddress> resultModel = new ExecResultModel<CabAddress>();
		int eventIntroduce = cabAddressMapper.deleteUserAddress(id,userId);
		resultModel.setRc(0);
		resultModel.setMsg("");
		resultModel.setTotal((long)eventIntroduce);
		return resultModel.getToJson(); 
	}
	/**
	 * 
	 * @Description：设置默认地址
	 * @author: zhuoHeng
	 * @version: 2016年4月13日 下午3:29:20
	 */
	public String setDefaultAess(String id,String userId){
		ExecResultModel<CabAddress> resultModel = new ExecResultModel<CabAddress>();
		cabAddressMapper.reSetDefaultAess(userId);
		int eventIntroduce = cabAddressMapper.setDefaultAess(id,userId);
		resultModel.setRc(0);
		resultModel.setMsg("");
		resultModel.setTotal((long)1);
		return resultModel.getToJson(); 
	}
	/**
	 * 添加我的常用地址
	 * @param userId
	 * @param name
	 * @param province
	 * @param city
	 * @param area
	 * @param address
	 * @param phoneNum
	 * @param postal
	 * @return
	 */
	public void postUserAddress(String userId, String name, String province,
			String city, String area, String address, String phoneNum,
			String postal) {
		CabAddress cabAddress = new CabAddress();
		cabAddress.setUserId(userId);
		cabAddress.setName(name);
		cabAddress.setAddress(address);
		cabAddress.setPhonenum(phoneNum);
		cabAddress.setPostal(postal);
		cabAddress.setProvince(province);
		cabAddress.setCity(city);
		cabAddress.setArea(area);
	    cabAddressMapper.insertSelective(cabAddress);
	}
	/**
	 * 修改我的常用地址
	 * @param userId
	 * @param id
	 * @param name
	 * @param province
	 * @param city
	 * @param area
	 * @param address
	 * @param phoneNum
	 * @param postal
	 * @param defaultAess
	 * @return
	 */
	public void putUserAddress(String userId, String id, String name,
			String province, String city, String area, String address,
			String phoneNum, String postal, String defaultAess) {
		CabAddress cabAddress = new CabAddress();
		cabAddress.setUserId(userId);
		cabAddress.setId(Integer.parseInt(id));
		cabAddress.setName(name);
		cabAddress.setAddress(address);
		cabAddress.setPhonenum(phoneNum);
		cabAddress.setPostal(postal);
		cabAddress.setDefaultArss(Integer.parseInt(defaultAess));
		cabAddress.setProvince(province);
		cabAddress.setCity(city);
		cabAddress.setArea(area);
		cabAddressMapper.updateByPrimaryKeySelective(cabAddress);
	}
}
