package com.sys.controller;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.util.JSONUtils;
import com.cku.util.ServletUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sys.model.Area;
import com.sys.model.AreaTreeResponse;
import com.sys.service.AreaServiceImpl;

@Controller
@RequestMapping(value="sys-api/area")
public class AreaController {
	// private static final Logger logger = Logger.getLogger(ProvinceController.class);
	
	@Autowired
	public AreaServiceImpl areaService;
	
	@RequestMapping(value = "/list")
	public void api_list(HttpServletResponse response,HttpServletRequest request) throws IOException
	{
		RESTResponse result = null;
		try
		{
			String city_code = ServletUtils.getParameter(request, "city_code");
			PageBeanResult<Area> lp = areaService.getList(city_code);
			result = new RESTResponse("items", lp);
		}
		catch (Exception e)
		{
			result = new RESTResponse(e);
		}
		
		ServletUtils.writeResponse(response, result);
	}
	
	@RequestMapping(value = "/tree")
	public void areaTree(HttpServletResponse response,HttpServletRequest request) throws IOException{
		RESTResponse result = null;
		try
		{
			PageBeanResult<AreaTreeResponse> lp = areaService.findAreaTree();
			ObjectMapper mapper=new ObjectMapper();
			String jsonStr=mapper.writeValueAsString(lp);
			result = new RESTResponse("items",jsonStr);
		}
		catch (Exception e)
		{
			result = new RESTResponse(e);
		}
		ServletUtils.writeResponse(response, result);
	}
	
}
