package com.sys.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cab.model.TestCategory;
import com.cab.model.TestInterface;
import com.cab.service.TestCategoryServiceImpl;
import com.cab.service.TestInterfaceServiceImpl;
import com.cab.service.TestParamsServiceImpl;

@Controller
@RequestMapping(value="/apiDoc")
public class ApiController {
	@Autowired
	private TestCategoryServiceImpl testCategoryService;
	@Autowired
	private TestInterfaceServiceImpl testInterfaceService;
	@Autowired
	private TestParamsServiceImpl testParamsService;
	
	@RequestMapping(value="")
	public String index(Model model){
		List<TestCategory> categorys= testCategoryService.getTestCategoryAll();
		JSONArray array = new JSONArray();
		for(TestCategory category:categorys){
			JSONObject object = new JSONObject();
			object.put("id", category.getId());
			object.put("pId", category.getParentId());
			object.put("name", category.getName()+"(id:"+category.getId()+")");
			array.add(object);
		}
		model.addAttribute("categorys", array.toString());
		return "apiDoc/index";
	}
	
	
	@RequestMapping(value="/apiForm")
	public String form(Model model,HttpServletRequest request,HttpServletResponse response){
		String id = request.getParameter("id");
		
		List<TestCategory> categorys= testCategoryService.getTestCategoryAll();
		JSONArray array = new JSONArray();
		for(TestCategory category:categorys){
			JSONObject object = new JSONObject();
			object.put("id", category.getId());
			object.put("pId", category.getParentId());
			object.put("name", category.getName()+"(id:"+category.getId()+")");
			array.add(object);
		}
		
		model.addAttribute("categorys", array.toString());
		if(id!=null&&!id.equals("")){
			TestInterface ti = testInterfaceService.selectByPrimaryKey(Long.valueOf(id));
			model.addAttribute("id", id);
			model.addAttribute("in",ti);
			return "apiDoc/edit";
		}
		
		
		return "apiDoc/form";
	}
}
