package com.cab.controller;

import com.cab.model.ContentType;
import com.cab.model.TreeDemo;
import com.cab.service.ContentTypeServiceImpl;
import com.cku.core.RESTResponse;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * Created by user on 2016/5/16.
 */
@Controller
@RequestMapping("contentType")
public class ContentTypeController {

    @Autowired
    private ContentTypeServiceImpl contentTypeService;

    @RequestMapping("/getTree")
    public void getTree(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = null;
        try{
            List<TreeDemo> items = contentTypeService.selectAll();
            result = new RESTResponse("items", items);
        }catch (Exception e){
            result = new RESTResponse(e);
        }
        ServletUtils.writeResponse(response, result);
    }
    @RequestMapping("/getDetail")
    public void getDetail(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = null;
        try{
            String id = ServletUtils.getParameter(request,"id");
            ContentType item = contentTypeService.getDetail(id);
            result = new RESTResponse("item", item);
        }catch (Exception e){
            result = new RESTResponse(e);
        }
        ServletUtils.writeResponse(response, result);
    }
    @RequestMapping("/delDetail")
    public void delDetail(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = null;
        try{
            String id = ServletUtils.getParameter(request,"id");
            int item = contentTypeService.delDetail(id);
            if(item>0){
                result = new RESTResponse(0,"删除栏目成功！");
            }else{
                result = new RESTResponse(-1,"删除栏目失败！");
            }

        }catch (Exception e){
            result = new RESTResponse(e);
        }
        ServletUtils.writeResponse(response, result);
    }

    @RequestMapping("/updateDetail")
    public void updateDetail(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = null;
        try{
            String detailId = ServletUtils.getParameter(request,"detailId");
            String detailName = ServletUtils.getParameter(request,"detailName");
            String detailImgUrl = ServletUtils.getParameter(request,"detailImgUrl");
            int item = contentTypeService.updateDetail(detailId,detailName,detailImgUrl);
            if(item>0){
                result = new RESTResponse(0,"修改栏目成功！");
            }else{
                result = new RESTResponse(-1,"修改栏目失败！");
            }

        }catch (Exception e){
            result = new RESTResponse(e);
        }
        ServletUtils.writeResponse(response, result);
    }

    @RequestMapping("/saveDetail")
    public void saveDetail(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = null;
        try{
            String addDetailId = ServletUtils.getParameter(request,"addDetailId");
            String addDetailName = ServletUtils.getParameter(request,"addDetailName");
            String addDetailImgUrl = ServletUtils.getParameter(request,"addDetailImgUrl");
            Integer addDetailLevel = ServletUtils.getParameterInt(request,"addDetailLevel",1);
            String addDetailParentId = ServletUtils.getParameter(request,"addDetailParentId",null);
            int item = contentTypeService.saveDetail(addDetailId,addDetailName,addDetailImgUrl,addDetailLevel,addDetailParentId);
            if(item>0){
                result = new RESTResponse(0,"添加栏目成功！");
            }else if(item==-2){
                result = new RESTResponse(-2,"栏目id重复！");
            }else{
                result = new RESTResponse(-1,"添加栏目失败！");
            }

        }catch (Exception e){
            result = new RESTResponse(e);
        }
        ServletUtils.writeResponse(response, result);
    }
}
