package com.cab.controller.CaptchaFactory;

import com.wf.captcha.ArithmeticCaptcha;
import com.wf.captcha.ChineseGifCaptcha;
import com.wf.captcha.GifCaptcha;
import com.wf.captcha.SpecCaptcha;
import com.wf.captcha.base.Captcha;

public class CaptchaFactory {

	public Captcha getCaptcha(String type) {
		int width = 110;
		int height = 50;
		int len = 4;
		if (type == null) {
			return null;
		}

		// gif
		if (type.equals("png")) {
			return new SpecCaptcha(width, height, len);
		}

		// gif
		if (type.equals("gif")) {
			return new GifCaptcha(width, height, len);
		}
		// 数字计算
		if (type.equals("arithmetic")) {
			return new ArithmeticCaptcha(width, height, len);
		}
		// 中文
		if (type.equals("chineseGif")) {
			return new ChineseGifCaptcha(width, height, len);
		}
		return null;
	}
}
