package com.cab.controller;

import java.io.IOException;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import com.cab.service.CabMyLoveDogServiceImpl;
import com.cab.service.UserService;
import com.cku.core.RESTResponse;
import com.cku.upyun.ImageFtp;
import com.cku.util.PageBean;
import com.cku.util.ServletUtils;

@Controller
@RequestMapping("myDog")
public class CabMyLoveDogController {
	
	private static final Logger logger = Logger.getLogger(CabMyLoveDogController.class);
	
	@Autowired
	public CabMyLoveDogServiceImpl myLoveDogService;
	/**
	 * 
	 * @Description：根据当前登录人获取我的爱宠列表
	 * @author: zhuoHeng
	 * @version: 2016年4月9日 上午11:47:09
	 */
	@RequestMapping("/getMyLoveDog")
	public void getMyLoveDog(HttpServletResponse response,HttpServletRequest request)throws IOException {
		
		try {
			String userId = UserService.verifyUserId(request);
			PageBean pb = ServletUtils.getParameterBean(request);
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = myLoveDogService.getMyLoveDog(userId,pb);
			response.getWriter().write(str);
		} catch (Exception e) {
			ServletUtils.writeResponse(response, new RESTResponse(e));
			logger.error(e.getMessage());
		}
	}
	/**
	 * 根据当前登录删除我的爱宠信息
	 * @param response
	 * @param request
	 * @param userId
	 */
	@RequestMapping("/deleteMyLoveDog")
	public void deleteMyLoveDog(HttpServletResponse response, HttpServletRequest request,
			@RequestParam(value = "id",required = false)Integer id)throws IOException {
		try {
			String userId = UserService.verifyUserId(request);
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String deleteMyLoveDog = myLoveDogService.deleteMyLoveDog(id,userId);
			response.getWriter().write(deleteMyLoveDog);
		} catch (Exception e) {
			ServletUtils.writeResponse(response, new RESTResponse(e));
			logger.error(e.getMessage());
		}
	}
	/**
	 * 根据当前登录新增宠物信息
	 * @param response
	 * @param request
	 * @throws IOException 
	 */
	@RequestMapping(value="/addMyLoveDog")
	public void insertMyLoveDog(HttpServletResponse response, HttpServletRequest request,
			@RequestParam(value = "file", required = false) MultipartFile file) throws IOException{
		RESTResponse result=null;
		try {
			String userId = UserService.verifyUserId(request);
			String dogName = ServletUtils.getParameter(request, "dog_name");
			String pedigreeNum = ServletUtils.getParameter(request, "pedigree_num",null);
			String sex = ServletUtils.getParameter(request, "sex");
			String weight = ServletUtils.getParameter(request, "weight",null);
			String dogBirthday = "".equals(ServletUtils.getParameter(request, "dog_birthday",null))?null:ServletUtils.getParameter(request, "dog_birthday",null);
			String getHomeDate = "".equals(ServletUtils.getParameter(request, "dog_birthday",null))?null:ServletUtils.getParameter(request, "get_home_date",null);
			String dogType = ServletUtils.getParameter(request, "dogType");
			String typeName = ServletUtils.getParameter(request, "typeName");
			String fileName = "";
			String resultOra ="";
			if(file!=null){
				fileName = file.getOriginalFilename();
				if(!"".equals(fileName)){
					int lastIndex = fileName.lastIndexOf(".");
					String fileNameEnd = fileName.substring(lastIndex);
					String newFileName = UUID.randomUUID()+fileNameEnd;
					resultOra = ImageFtp.uploadBytes(ImageFtp.AVATAR_PATH_TEST, newFileName, file.getBytes());
				}
			}
			myLoveDogService.insertMyLoveDog(userId,dogName,pedigreeNum,sex,weight,dogBirthday,getHomeDate,dogType,resultOra,typeName);
			result=new RESTResponse();
		} catch (Exception e) {
			result = new RESTResponse(e);
			e.printStackTrace();
		}
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 根据当前登录修改宠物信息
	 * @param response
	 * @param request
	 * @param userId
	 * @throws IOException 
	 */
	@RequestMapping("/updateMyLoveDog")
	public void updateMyLoveDog(HttpServletResponse response, HttpServletRequest request,
			@RequestParam(value = "file", required = false) MultipartFile file) throws IOException{
		RESTResponse result=null;
		try {
			String userId = UserService.verifyUserId(request);
			String id=ServletUtils.getParameter(request, "id");
			String dogName = ServletUtils.getParameter(request, "dog_name");
			String pedigreeNum = ServletUtils.getParameter(request, "pedigree_num",null);
			String sex = ServletUtils.getParameter(request, "sex");
			String weight = ServletUtils.getParameter(request, "weight",null);
			String dogBirthday = "".equals(ServletUtils.getParameter(request, "dog_birthday",null))?null:ServletUtils.getParameter(request, "dog_birthday",null);
			String getHomeDate = "".equals(ServletUtils.getParameter(request, "dog_birthday",null))?null:ServletUtils.getParameter(request, "get_home_date",null);
			String dogType = ServletUtils.getParameter(request, "dogType");
			String typeName = ServletUtils.getParameter(request, "typeName");
			String fileName = "";
			String resultOra ="";
			if(file!=null){
				fileName = file.getOriginalFilename();
				if(!"".equals(fileName)){
				int lastIndex = fileName.lastIndexOf(".");
					String fileNameEnd = fileName.substring(lastIndex);
					String newFileName = UUID.randomUUID()+fileNameEnd;
					resultOra = ImageFtp.uploadBytes(ImageFtp.AVATAR_PATH_TEST, newFileName, file.getBytes());
				}
			}
		    myLoveDogService.updateMyLoveDog(id,userId,dogName,pedigreeNum,sex,weight,dogBirthday,getHomeDate,dogType,resultOra,typeName);
            result=new RESTResponse();
		} catch (Exception e) {
			result = new RESTResponse(e);
			e.printStackTrace();
		}
		ServletUtils.writeResponse(response, result);
	}
}
	

