package com.cku.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cku.core.BaseDAOMapper;
import com.cku.core.BaseService;
import com.cku.core.ExecResultModel;
import com.cku.dao.CkuImageMapper;
import com.cku.dao.ShowVenueMapper;
import com.cku.model.ShowVenue;

@Service("showVenueSerivce")
public class ShowVenueServiceImpl  extends BaseService<ShowVenue>{
	@Autowired
	public ShowVenueMapper showVenueMapper;
	
	@Autowired
	public CkuImageMapper ckuImageMapper;
	@Override
	protected BaseDAOMapper<ShowVenue> getDAO() {
		return this.showVenueMapper;
	}
	public String getVenue(String showLocation){
		ExecResultModel<ShowVenue> resultModel = new ExecResultModel<ShowVenue>();
		List<ShowVenue> list = new ArrayList<ShowVenue>();
		ShowVenue showVenue = showVenueMapper.getVenue(showLocation);
		if(showVenue==null){
			resultModel.setItems(new ArrayList<ShowVenue>());
			resultModel.setTotal((long) list.size());
			resultModel.setRc(0);
			resultModel.setMsg("无对应数据");
		}else{
			list.add(showVenue);
			resultModel.setItems(list);
			resultModel.setTotal((long) list.size());
			resultModel.setRc(0);
			resultModel.setMsg("");
		}
		
		return resultModel.getToJson();
	}


}
