package com.cku.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.core.PageBeanResult;
import com.cku.model.CkuMatch;
import com.cku.model.CkuMatchSponsor;
import com.cku.model.EventRelatedModel;

public interface EventRelatedMapper{
	
	/**
	 * 已改
	 * @Description：根据页码、展示条数获取主赛事列表
	 * @author: zhuoHeng
	 * @version: 2016年3月15日 下午6:07:59
	 */
	public List<EventRelatedModel> getEventList(@Param("page")Integer page,@Param("limit")Integer limit);
	
	/**
	 * 获取未进行赛事总条数
	 * @Description：(使用一句话对方法进行描述)
	 * @author: zhuoHeng
	 * @version: 2016年5月11日 下午2:45:04
	 */
	public List<EventRelatedModel> getEventCount();
	/**
	 * 
	 * @Description：根据主赛事场地查询子赛事列表 
	 * @author: zhuoHeng
	 * @version: 2016年3月16日 上午11:28:32
	 */
	public List<EventRelatedModel> getSpecificEvent(@Param("showLocation")String showLocation,@Param("ids") String ids);
	/**
	 * 
	 * @Description：根据赛主事场地查询主赛事信息
	 * @author: zhuoHeng
	 * @version: 2016年3月19日 上午10:26:43
	 */
	public List<EventRelatedModel> getTrunkEventInfo(@Param("showLocation")String showLocation);
	/**
	 * 
	 * @Description：根据主办方获取主办方详细信息
	 * @author: zhuoHeng
	 * @version: 2016年3月22日 下午6:11:18
	 */
	public List<CkuMatchSponsor> getSponsorInfo(@Param("organizer")String organizer);
	/**
	 * 已改
	 * @Description：根据赛事编号获取赛事信息
	 * @author: zhuoHeng
	 * @version: 2016年4月2日 下午1:36:27
	 */
	public EventRelatedModel getSpecificEventByShowNum(@Param("showNum") String showNum);
	/**
	 * 已改
	 * @Description：根据赛事编号查询最小开始日期
	 * @author: zhuoHeng
	 * @version: 2016年4月21日 上午10:49:39
	 */
	public EventRelatedModel getSpecificEventByShowNums(@Param("showNums") String showNums);
	/**
	 * 修改赛事为是否推荐
	 * @Author chaixueteng
	 * @2016年5月4日下午2:37:17
	 */
	public int updateMatchToTop(@Param("showLocation")String showLocation,@Param("isTop")Integer isTop);
	/**
	 * 查询赛事为推荐赛事
	 * @param m 
	 * @param l 
	 * @Author chaixueteng
	 * @2016年5月4日下午4:02:15
	 */
	public List<EventRelatedModel> getTopMatch(@Param("start")Integer start,@Param("limit")Integer limit);
	
	/**
	 * 根据赛事id查询出赛事地点
	 * @Author chaixueteng
	 * @2016年5月6日下午3:03:04
	 */
	public String getMatchByAdress(@Param("id")Integer id);
	/**
	 * 根据id查找推荐配图
	 * @Author chaixueteng
	 * @2016年5月9日下午6:27:48
	 */
	String getMatchImage(@Param("id")String id);
	
	
	String getShowOfficeManager(@Param("showOfficeId")String showOfficeId);
		
}