package com.cab.service;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cab.dao.CabSysUserMapper;

@Service("userService")
public class UserServiceImpl{
	
	@Autowired
	private CabSysUserMapper cabSysUserMapper;
	
	/**
	 * 
	 * @Description：通过token验证返回 俱乐部 登录账号id
	 * @author: zhangjunwu
	 * @version: 2020-05-25
	 */
	public String validate(String userId,String club) {
        //根据cab用户id查询出第三方表中对应的CKU账号信息
        String dvUserId = cabSysUserMapper.selectThirdUserId(userId,club);
        return StringUtils.isBlank(dvUserId)?"-1" : dvUserId;
	}

}
