package com.sys.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.cku.core.BaseDAOMapper;
import com.cku.core.BaseService;
import com.cku.core.PageBeanResult;
import com.sys.dao.CityMapper;
import com.sys.model.City;

@Service("cityService")
public class CityServiceImpl extends BaseService<City>{
	@Autowired
	public CityMapper cityMapper;
	
	@Override
	protected BaseDAOMapper<City> getDAO() {
		return this.cityMapper;
	}
	
	public PageBeanResult<City> getList(String provinceCode){
		
		List<City> list = cityMapper.selectByProvinceId(provinceCode);
		
		PageBeanResult<City> prResult = new PageBeanResult<City>();
		prResult.list = list;
		prResult.totalCount = (long)list.size();
		
		return prResult;
	}

}
