package com.cku.controller;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import com.alibaba.fastjson.JSONObject;
import com.cab.service.UserService;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.model.CkuOrder;
import com.cku.service.CkuDogEnteredServiceImpl;
import com.cku.util.Debugger;
import com.cku.util.ServletUtils;
import com.sys.model.MultiUserProfile;

@Controller
@RequestMapping("dog/entered")
public class CkuDogEnteredController {

	private static Logger logger = Logger.getLogger(CkuDogEnteredController.class);
	@Autowired
	private CkuDogEnteredServiceImpl ckuDogEnteredService;

	/**
	 *
	 * @Description：犬只赛事报名
	 * @author: zhuoHeng
	 * @version: 2016年4月19日 上午10:00:53
	 */
	@RequestMapping("/generateOrder")
	public void dogEventEntered(@RequestBody(required = false) String json, HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = null;
		try {
			String showNums;
			String pedigreeNum;
			String detil;
			String ageGroup;
			String bbeFlag;
			String couponNum;
			String stickerFlag;
			String isOwner;
			if (StringUtils.isNotBlank(json)) {
				JSONObject jo = JSONObject.parseObject(json);
				logger.info("赛事创建参数------:" + jo.toJSONString());
				showNums = getParameter(jo, "showNums");
				pedigreeNum = getParameter(jo, "pedigreeNum");
				detil = getParameter(jo, "detil");
				ageGroup = getParameter(jo, "ageGroup", null);
				bbeFlag = getParameter(jo, "bbeFlag", "0");
				couponNum = getParameter(jo, "couponNum", "0");
				stickerFlag = getParameter(jo, "stickerFlag", "0");
				isOwner = getParameter(jo, "isOwner", null);
			} else {
				showNums = ServletUtils.getParameter(request, "showNums");
				pedigreeNum = ServletUtils.getParameter(request, "pedigreeNum");
				detil = ServletUtils.getParameter(request, "detil");
				ageGroup = ServletUtils.getParameter(request, "ageGroup", null);
				bbeFlag = ServletUtils.getParameter(request, "bbeFlag", "0");
				couponNum = ServletUtils.getParameter(request, "couponNum", "0");
				stickerFlag = ServletUtils.getParameter(request, "stickerFlag", "0");
				isOwner = ServletUtils.getParameter(request, "isOwner", null);
			}
			MultiUserProfile userProfile = UserService.verifyTokenObj(request);
			CkuOrder ckuOrderInfo = ckuDogEnteredService.dogEventEntered(userProfile, showNums, pedigreeNum, detil,
					ageGroup, bbeFlag, couponNum, stickerFlag, isOwner);
			result = new RESTResponse("item", ckuOrderInfo);
		} catch (Exception e) {
			if (e instanceof ZAException) {
				ZAException sre = (ZAException) e;
				result = new RESTResponse(sre.get_code(), sre.getMessage());
			} else {
				result = new RESTResponse(e);
			}
		}

		ServletUtils.writeResponse(response, result);
	}

	private String getParameter(JSONObject jo, String paramName) throws ZAException {
		String p = jo.getString(paramName);
		Debugger.doAssert(p != null, ZAErrorCode.ZA_ERC_INVALID_PARAMETER,
				String.format("paremeter '%s' was not found", paramName));
		return p;
	}

	private String getParameter(JSONObject jo, String paramName, String defaultVal) throws ZAException {
		String p = jo.getString(paramName);
		if (p == null)
			return defaultVal;
		return p;
	}

	/**
	 *
	 * @Description：余额支付赛事费用
	 * @author: zhuoHeng
	 * @version: 2016年4月20日 上午10:18:27
	 */
	@RequestMapping("/eventBalancePayment")
	public void eventBalancePayment(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = null;
		try {
			MultiUserProfile userProfile = UserService.verifyTokenObj(request);
			String orderID = ServletUtils.getParameter(request, "orderID");
			String pid = ServletUtils.getParameter(request, "pid");
			String payPsw = ServletUtils.getParameter(request, "payPsw");
			String dynamic = ServletUtils.getParameter(request, "dynamic");
			ckuDogEnteredService.eventBalancePayment(userProfile, orderID, pid, payPsw, dynamic);
			result = new RESTResponse();
		} catch (Exception e) {
			result = new RESTResponse(e);
		}

		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：赛事报名取消订单
	 * @author: zhuoHeng
	 * @version: 2016年4月21日 上午11:56:34
	 */
	@RequestMapping("cancelTheOrder")
	public void cancelTheOrder(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = null;
		try {
			MultiUserProfile userProfile = UserService.verifyTokenObj(request);
			String orderID = ServletUtils.getParameter(request, "orderId");
			ckuDogEnteredService.cancelTheOrder(userProfile, orderID);
			result = new RESTResponse();
		} catch (Exception e) {
			result = new RESTResponse(e);
		}

		ServletUtils.writeResponse(response, result);
	}

}
