package com.cku.controller;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.model.BirthCertificate;
import com.cku.service.BirthCertificateServiceImpl;
import com.cku.util.PageBean;
import com.cku.util.ServletUtils;

/**
 * 
 * <p>Title:BirthCertificateController </p>
 * <p>Description:新生犬出生纸信息控制层 </p>
 * <p>Company: </p> 
 * @author zhuoHeng
 * @date 2016年7月27日 上午9:34:42
 */
@Controller
@RequestMapping(value = "dog/birthCertificate")
public class BirthCertificateController {

    @Autowired
    public BirthCertificateServiceImpl birthCertificateService;
    
    /**
     * 
     * @Description：根据出生纸编号查询出生纸信息
     * @author: zhuoHeng
     * @version: 2016年7月27日 上午9:59:45
     * @throws IOException 
     */
    @RequestMapping("/getBirthCertificate")
    public void getBirthCertificate(HttpServletResponse response, HttpServletRequest request) throws IOException{
        RESTResponse result = null;
        try {
            String birthCertificateCode = ServletUtils.getParameter(request, "birthCertificateCode");
            BirthCertificate data = birthCertificateService.getBirthCertificate(birthCertificateCode);
            result = new RESTResponse("data", data);
        } catch (Exception e) {
            result = new RESTResponse(e);
        }
        ServletUtils.writeResponse(response, result);
    }
    
    /**
     * 
     * @Description：分页查询某会员拥有的所有出生纸信息/分页查询某配种编号下所有出生纸信息
     * @author: zhuoHeng
     * @version: 2016年7月27日 下午12:04:44
     */
    @RequestMapping("/getBirthCertificateByMemberNum")
    public void getBirthCertificateByMemberNum(HttpServletResponse response, HttpServletRequest request) throws IOException{
        RESTResponse result = null;
        try {
            String MemberNum = ServletUtils.getParameter(request, "MemberNum",null);
            String breedCertifiedNum = ServletUtils.getParameter(request, "breedCertifiedNum",null);
            PageBean pb=ServletUtils.getParameterBean(request);
            PageBeanResult<BirthCertificate> list = birthCertificateService.getBirthCertificateByMemberNum(MemberNum,breedCertifiedNum,pb);
            result = new RESTResponse("data", list);
        } catch (Exception e) {
            result = new RESTResponse(e);
        }
        ServletUtils.writeResponse(response, result);
    }
}
