package com.cab.service;

import com.cab.dao.CabLiveContentMapper;
import com.cab.model.CabLiveContent;
import com.cku.core.BaseDAOMapper;
import com.cku.core.BaseService;
import com.cku.core.PageBeanResult;
import com.cku.upyun.ImageFtp;
import com.cku.util.PageBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * Created by user on 2016/6/28.
 */
@Service("cabLiveContentService")
public class CabLiveContentServiceImpl extends BaseService<CabLiveContent> {
    @Autowired
    public CabLiveContentMapper cabLiveContentMapper;
    @Override
    protected BaseDAOMapper<CabLiveContent> getDAO() {
        return this.cabLiveContentMapper;
    }

    public List<CabLiveContent> queryList(Long selectId){
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(now);
        List<CabLiveContent> list = cabLiveContentMapper.queryList(selectId,dateString);
        return list;
    }
    public PageBeanResult<CabLiveContent> selectAll(String title, PageBean pb){
        PageBeanResult<CabLiveContent> pbList = new PageBeanResult<CabLiveContent>();
        List<CabLiveContent> list = cabLiveContentMapper.selectAll(title,pb.get_start(),pb.get_limit());
        Long count = cabLiveContentMapper.selectCount(title);
        pbList.setList(list);
        pbList.setTotalCount(count);
        return pbList;
    }

    public void updateTime(Long contentId,String time){
        CabLiveContent cabLiveContent = new CabLiveContent();
        cabLiveContent.setContentId(contentId.intValue());
        cabLiveContent.setVideoTime(time);
        cabLiveContentMapper.updateByPrimaryKeySelective(cabLiveContent);
    }
    @Override
    public int deleteByPrimaryKey(Long id) {
        CabLiveContent cabLiveContent = getDAO().selectByPrimaryKey(id);
        this.deleteFile(cabLiveContent);
        return getDAO().deleteByPrimaryKey(id);
    }

    @Override
    public int updateByPrimaryKeySelective(CabLiveContent record) {
        CabLiveContent cabLiveContent = cabLiveContentMapper.selectByPrimaryKey(record.getContentId());
        this.deleteFile(cabLiveContent);
        return getDAO().updateByPrimaryKeySelective(record);
    }

    public void deleteFile(CabLiveContent oldContentEntity) {
        //判断旧图片和旧视频是否哈希和字符相同再做删除操作
        String thumbUrl = oldContentEntity.getThumbUrl();
        //得到旧图文信息里的缩略图
        String thumbMinUrl = oldContentEntity.getThumbMinUrl();
        //得到旧图文里的视频地址
        String videoUrl = oldContentEntity.getVideoUrl();
        //得到旧图文信息里的图
        String preheatImg = oldContentEntity.getPreheatImg();
        if(thumbUrl!=null && !"".equals(thumbUrl) && thumbUrl.length()> ImageFtp.UPYUNWEBURL.length() &&thumbUrl.startsWith(ImageFtp.UPYUNWEBURL)){
            ImageFtp.deleteFile(thumbUrl.replace(ImageFtp.UPYUNWEBURL, ""));
        }
        //删除原有缩略图
        if(thumbMinUrl!=null && !"".equals(thumbMinUrl) && thumbMinUrl.length()>ImageFtp.UPYUNWEBURL.length() &&thumbMinUrl.startsWith(ImageFtp.UPYUNWEBURL)){
            ImageFtp.deleteFile(thumbMinUrl.replace(ImageFtp.UPYUNWEBURL, ""));
        }
        //删除原有视频
        if( videoUrl!=null && !"".equals(videoUrl) && videoUrl.length()>ImageFtp.UPYUNWEBURL.length() &&videoUrl.startsWith(ImageFtp.UPYUNWEBURL)){
            ImageFtp.deleteFile(videoUrl.replace(ImageFtp.UPYUNWEBURL, ""));
        }
        //删除原有视频
        if( preheatImg!=null && !"".equals(preheatImg) && preheatImg.length()>ImageFtp.UPYUNWEBURL.length() &&videoUrl.startsWith(ImageFtp.UPYUNWEBURL)){
            ImageFtp.deleteFile(preheatImg.replace(ImageFtp.UPYUNWEBURL, ""));
        }
    }
}
