 package com.cab.controller;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cab.service.UserAddressServiceImpl;
import com.cab.service.UserService;
import com.cku.core.RESTResponse;
import com.cku.util.ServletUtils;

@Controller
@RequestMapping(value="userAddress")
public class UserAddressController {
	
	private static final Logger logger = Logger.getLogger(UserAddressController.class);
	
	@Autowired
	public UserAddressServiceImpl userAddressService;
	/**
	 * 
	 * @Description：获取用户地址列表
	 * @author: zhuoHeng
	 * @version: 2016年4月5日 下午4:18:45
	 */
	@RequestMapping(value = "/getUserAddress")
	public void getUserAddress(HttpServletResponse response,HttpServletRequest request){
		try {
			String userId = UserService.verifyUserId(request);
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = userAddressService.getUserAddress(userId);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
	/**
	 * 
	 * @Description：添加我的常用地址
	 * @author: zhuoHeng
	 * @version: 2016年4月5日 下午4:38:13
	 * @throws IOException 
	 */
	@RequestMapping(value = "/postUserAddress")
	public void postUserAddress(HttpServletResponse response,HttpServletRequest request) throws IOException{
		RESTResponse result=null;
		try {
			String userId = UserService.verifyUserId(request);
			String name = ServletUtils.getParameter(request, "name");
			String province = ServletUtils.getParameter(request, "province",null);
			String city = ServletUtils.getParameter(request, "city",null);
			String area = ServletUtils.getParameter(request, "area",null);
			String address = ServletUtils.getParameter(request, "address");
			String phoneNum = ServletUtils.getParameter(request, "phoneNum");
			String postal = ServletUtils.getParameter(request, "postal");
			userAddressService.postUserAddress(userId,name,province,city,area,address,phoneNum,postal);
			result=new RESTResponse();
		} catch (Exception e) {
			result = new RESTResponse(e);
			e.printStackTrace();
		}
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 
	 * @Description：修改我的常用地址
	 * @author: zhuoHeng
	 * @version: 2016年4月5日 下午5:29:58
	 * @throws IOException 
	 */
	@RequestMapping(value = "/putUserAddress")
	public void putUserAddress(HttpServletResponse response,HttpServletRequest request) throws IOException{
		RESTResponse result=null;
		try {
			String userId = UserService.verifyUserId(request);
			String id = ServletUtils.getParameter(request, "id");
			String name = ServletUtils.getParameter(request, "name");
			String province = ServletUtils.getParameter(request, "province",null);
			String city = ServletUtils.getParameter(request, "city",null);
			String area = ServletUtils.getParameter(request, "area",null);
			String address = ServletUtils.getParameter(request, "address");
			String phoneNum = ServletUtils.getParameter(request, "phoneNum");
			String postal = ServletUtils.getParameter(request, "postal");
			String defaultAess = ServletUtils.getParameter(request, "defaultAess");
			userAddressService.putUserAddress(userId,id,name,province,city,area,address,phoneNum,postal,defaultAess);
			result= new RESTResponse();
		} catch (Exception e) {
			result = new RESTResponse(e);
			e.printStackTrace();
		}
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 
	 * @Description：删除我的常用地址
	 * @author: zhuoHeng
	 * @version: 2016年4月5日 下午6:10:13
	 */
	@RequestMapping(value = "/deleteUserAddress")
	public void deleteUserAddress(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "id", required = false)String id){
		try {
			String user_id = UserService.verifyUserId(request);
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = userAddressService.deleteUserAddress(id,user_id);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
	/**
	 * 
	 * @Description：设置默认地址
	 * @author: zhuoHeng
	 * @version: 2016年4月13日 下午3:28:34
	 */
	@RequestMapping("/setDefaultAess")
	public void setDefaultAess(HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "id", required = false)String id,
			@RequestParam(value = "token", required = false)String String){
		try {
			String user_id = UserService.verifyUserId(request);
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = userAddressService.setDefaultAess(id,user_id);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}

}
