<%@ page language="java" contentType="text/html;charset=UTF-8" %> 
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %> 
<%@ page isELIgnored="false" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
        "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>赛事酒店列表</title>
    <meta http-equiv="Content-Type" content="text/html;charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap/css/bootstrap.min.css">
	<link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap/css/bootstrap-theme.min.css">
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/bootstrap/js/bootstrap.min.js"></script>
	<script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/jquery.twbsPagination/jquery.twbsPagination.js"></script>
</head>
<body>
<div class="container-fluid">
			<form class="form-inline">
			<div class="row">
			  <div class="form-group col-md-6">
			    <label>酒店名称:</label>
			    <input type="text" name="hotelName" value="${param.hotelName==null?'':param.hotelName}" style="width: inherit;" class="form-control" placeholder="中英文名称">
			  </div>
			  <div class="form-group col-md-6">
			    <label>酒店地址:</label>
			    <input type="text" name="hotelAddress" value="${param.hotelAddress==null?'':param.hotelAddress}" style="width: inherit;" class="form-control" placeholder="类别">
			  </div>			
			</div>	
			<input type="hidden" id="pageval" name="page" class="form-control" value="${param.page==null?1:param.page}">
			<input type="hidden" name="limit" class="form-control" value="10">
			<div class="alert alert-default" role="alert" style="text-align: center;">
				<button type="button" id="subbtn" class="btn btn-default">提交</button>
		  		<button type="reset" class="btn btn-default">重置</button>
		  		<a href="<%=request.getContextPath() %>/ckuMatchHotel/toUpdate.do?type=add" type="button" class="btn btn-success">添加</a>
			</div>

			    <table class="table">
			      <thead>
			        <tr>
			          <th>ID</th>
			          <th>酒店名称</th>
			          <th>酒店地址</th>
			          <th>操作</th>
			        </tr>
			      </thead>
			      <tbody id="showcontent">
					<c:forEach var="item" items="${pageList.list}">
				        <tr>
				          <td>${item.id}</td>
				          <td>${item.hotelName}</td>
				          <td>${item.hotelAddress}</td>
				          <td>
				          		<a type="button" class="btn btn-info" href="<%=request.getContextPath() %>/ckuMatchHotel/toUpdate.do?type=edit&id=${item.id}">修改</a>
				          		<button type="button" onclick="del(${item.id})" class="btn btn-danger">删除</button>
				          </td>
				        </tr>
					</c:forEach>
			      </tbody>
			    </table>
			    <nav id="pagination_box"><ul class="pagination" id="pagercontent"></ul></nav>
			 </form>   
</div>
<script>
$("#subbtn").on("click",function(){
	$('#pageval').val(1);
    $("form").submit();
})
$('#pagercontent').twbsPagination({
	  startPage: ${param.page==null?1:param.page},
	  initiateStartPageClick: false,
	  totalPages: ${pageList.totalCount}==0?1:Math.ceil(${pageList.totalCount}/10),
	  onPageClick: function (event, page) {
	    $('#pageval').val(page);
	    $("form").submit();
	  }
	});
	function del(id){
		$.ajax({
			type:"get",
			url:"<%=request.getContextPath() %>/ckuMatchHotel/deleteMatchHotel.do",
			data:{id:id},
 			dataType: 'json',
	        timeout: 30000,
	        success: function(json){
	        	console.log(json);
	        	alert(json.msg);
	        	if(json.rc==0){
	    			window.location.reload();
	    		}
	        },
	        error: function(xhr, type){
	            
	        }
		});
	}
	
</script>	
</body>
</html>
