/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.dao;

import java.util.Date;

import org.apache.ibatis.annotations.Param;

import com.cku.core.BaseDAOMapper;
import com.cku.model.ShowApplyDiscount;

/**
 * 报名满减优惠表DAO接口
 * @author xx
 * @version 2022-09-13
 */
public interface ShowApplyDiscountMapper extends BaseDAOMapper<ShowApplyDiscount>{ 
	
	/**
	 * 找到一个主赛事 一个犬主名下的最后一个周期
	 * @param showMainId
	 * @param discountSign
	 * @return
	 */
	String getLastCycleSign(@Param("showMainId") String showMainId,
			@Param("discountSign") String discountSign);
	/**
	 * 找到这个周期有多少个有效订单
	 * @param cycleSign
	 * @return
	 */
	Integer countByCycleSign(@Param("cycleSign") String cycleSign);
	
	/**
	 * 计算某个犬在某日期后有无犬主变更
	 * @param reviewBeginDate
	 * @param dogId
	 * @return
	 */
	Integer countDogOwnerChangeByReviewTime(@Param("reviewBeginDate") Date reviewBeginDate,@Param("dogId") String dogId);
	
	/**
	 * 当前犬主名下犬只有未缴费的赛事订单
	 * @param dogOwnerMemberCode
	 * @return
	 */
	int countUnpaidShowAppByDogOwnerMemberCode(@Param("dogOwnerMemberCode") String dogOwnerMemberCode);
	
	/**
	 * 找到这个周期有多少个有效订单
	 * @param cycleSign
	 * @return
	 */
	Integer countDiscountByCycleSign(@Param("cycleSign") String cycleSign);
	
}