package com.cku.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.model.CkuUserPayList;
import com.cku.model.SPOrderInfo;
import com.cku.model.SPOrderInfoNew;

public interface SPOrderInfoMapper {
    int deleteByPrimaryKey(Integer id);

    int insert(SPOrderInfo record);

    int insertSelective(SPOrderInfo record);

    SPOrderInfo selectByPrimaryKey(String id);

    int updateByPrimaryKeySelective(SPOrderInfo record);

    int updateByPrimaryKeyWithBLOBs(SPOrderInfo record);

    int updateByPrimaryKey(SPOrderInfo record);

	List<SPOrderInfo> selectPayOrder(@Param("ckuId") String ckuId, @Param("PayConfirm") String payconfirm, @Param("indexNum") long indexNum,@Param("count") long count);
	
	/**
	 * 已改
	 * @Description：根据登录人会员号和支付标识查询订单
	 * @author: zhuoHeng
	 * @version: 2016年9月9日 下午2:29:10
	 */
	List<SPOrderInfoNew> selectPayOrderNew(@Param("ckuId") String ckuId, @Param("PayConfirm") String payconfirm, @Param("indexNum") long indexNum,@Param("count") long count);

	/**
	 * 已改
	 * @Description：根据会员号和支付状态查询赛事订单总数
	 * @author: zhuoHeng
	 * @version: 2016年9月13日 上午10:03:42
	 */
	Long getCount(@Param("ckuId") String ckuId, @Param("PayConfirm") String payconfirm);
	
	/**
	 * 已改
	 * @Description：根据订单号查询订单详细
	 * @author: zhuoHeng
	 * @version: 2016年4月20日 上午10:37:16
	 */
	SPOrderInfo selectByOrderID(@Param("OrderID") String OrderID,@Param("ckuId") String ckuId);
	/**
	 * 已改
	 * @Description：根据订单号修改订单表支付标识
	 * @author: zhuoHeng
	 * @version: 2016年4月20日 下午12:57:37
	 */
	int updateOrderPayConfim(@Param("orderID") String orderID);
	/**
	 * 已改
	 * @Description：取消订单删除订单表记录
	 * @author: zhuoHeng
	 * @version: 2016年4月21日 下午1:18:42
	 */
	int deleteByOrderId(@Param("userId") String userId,@Param("orderId") String orderId);
	
	
    /**
     * 已改
     * 查询未支付的订单
     * @param ckuId
     * @return
     */
    int checkSignUnfinished(@Param("ckuId")String ckuId);
    
    /**
     * 
     * @Description：查询购物车中商品数量
     * @author: zhuoHeng
     * @version: 2017年2月15日 下午5:06:43
     */
    int countPaymentCart(@Param("memberCode")String memberCode);
}