package com.cku.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.core.BaseDAOMapper;
import com.cku.model.CkuDog;
import com.cku.model.CkuDogMessageForLoginType;

public interface CkuDogMapper{
    /**
     * 已改
     * @Description：根据cku证书号/犬只芯片号获取犬信息
     * @author: zhuoHeng
     * @version: 2016年3月16日 下午4:59:20
     */
	public List<CkuDog> getMatchCost (@Param("pedigreeNum")String pedigreeNum,@Param("dogId") String dogId);

	/**
	 * 已改
	 * @Description：根据会员号跟CKU血统证书号查询犬只信息
	 * @author: zhuoHeng
	 * @version: 2016年4月14日 上午10:14:24
	 * @param m
	 * @param l
	 */
	public List<CkuDogMessageForLoginType> getMatchCostByPedigreeNum (@Param("userNum")String userNum,@Param("pedigreeNum") String pedigreeNum);

	/**
	 * 已改
	 * @Description：根据会员号获取会员名下犬只列表
	 * @author: zhuoHeng
	 * @version: 2016年9月10日 下午2:33:26
	 */
	public List<CkuDog> getDogListByLoginUser(@Param("userNum") String userNum, @Param("limit")Long limit,@Param("count")Long count);
	/**
	 * 得到狗的芯片号
	 * @param ckuZsid
	 * @return
	 */
	public String getDogCord(@Param("ckuZsid")String ckuZsid);

	/**
	 * 根据当前登陆人查询犬只列表总数
	 * @Author chaixueteng
	 * @2016年5月26日上午9:44:46
	 */
	public long getCountByLoginUser(@Param("userNum") String userNum);

	/**
	 *
	 * @Description：根据血统证书号获取犬只是否存在有效的冠军登录申请
	 * @author: zhuoHeng
	 * @version: 2017年2月23日 下午2:55:52
	 */
	public int getChampionLogin(@Param("pedigreeCertified") String pedigreeCertified);

	void updateDogGeneration(@Param("generation")String generation, @Param("pedigreeNum")String pedigreeNum);
	
	CkuDog getByPedigreeCertifiedCode(@Param("pedigreeNum")String pedigreeNum);
}