package com.cku.controller;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.cku.core.RESTResponse;
import com.cku.model.Dog;
import com.cku.service.BreedCertifiedServiceImpl;
import com.cku.util.ServletUtils;

/**
 * 
 * <p>Title:BreedCertifiedController </p>
 * <p>Description: 配种证明功能控制层</p>
 * <p>Company: </p> 
 * @author zhuoHeng
 * @date 2016年7月28日 上午10:15:31
 */
@Controller
@RequestMapping(value = "breedCertified")
public class BreedCertifiedController {
    
    @Autowired
    public BreedCertifiedServiceImpl breedCertifiedService;

    /**
     * 
     * @Description：根据会员号、血统证书号、性别查询犬只信息
     * @author: zhuoHeng
     * @version: 2016年7月28日 上午10:16:00
     * @throws IOException 
     */
    @RequestMapping(value = "/dog",method = RequestMethod.GET)
    public void getDogInfo(HttpServletRequest request,HttpServletResponse response) throws IOException{
        RESTResponse result = null;
        try {
            String memberNum = ServletUtils.getParameter(request, "memberNum", null);           //会员号
            String pedigreeCertified = ServletUtils.getParameter(request, "pedigreeCertified"); //血统证书号
            String dogGender = ServletUtils.getParameter(request, "dogGender");                 //犬只性别
            Dog dogInfo = breedCertifiedService.getDogInfo(memberNum,pedigreeCertified,dogGender);
            result = new RESTResponse("data", dogInfo);
        } catch (Exception e) {
            result = new RESTResponse(e);
        }
        ServletUtils.writeResponse(response, result);
    }
    
    /**
     * 
     * @Description：会员提交犬只配种证明申请
     * @author: zhuoHeng
     * @version: 2016年7月28日 上午11:40:23
     * @throws IOException 
     */
    @RequestMapping(value = "/breedCertified")
    public void addBreedCertified(HttpServletRequest request,HttpServletResponse response) throws IOException{
        RESTResponse result = null;
        try {
            String memberNum = ServletUtils.getParameter(request, "memberNum", null);                       //公犬主会员号
            String breedDate = ServletUtils.getParameter(request, "breedDate");                             //配种日期
            String malePedigreeCertified = ServletUtils.getParameter(request, "malePedigreeCertified");     //公犬血统证书号
            String femalePedigreeCertified = ServletUtils.getParameter(request, "femalePedigreeCertified"); //母犬血统证书号
            String urgent = ServletUtils.getParameter(request, "urgent");                                   //加急
            breedCertifiedService.addBreedCertified(memberNum,breedDate,malePedigreeCertified,femalePedigreeCertified,urgent);
            result = new RESTResponse();
        } catch (Exception e) {
            result = new RESTResponse(e);
        }
        ServletUtils.writeResponse(response, result);
    }
}
