/*
 * Decompiled with CFR 0.152.
 */
package com.cku.config;

import com.cku.util.PropertiesLoader;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.io.DefaultResourceLoader;

public class Global {
    private static Global global = new Global();
    private static Map<String, String> map = Maps.newHashMap();
    private static PropertiesLoader loader = new PropertiesLoader("config.properties");
    public static final String SHOW = "1";
    public static final String HIDE = "0";
    public static final String YES = "1";
    public static final String NO = "0";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String USERFILES_BASE_URL = "/userfiles/";

    public static Global getInstance() {
        return global;
    }

    public static String getConfig(String key) {
        String value = map.get(key);
        if (value == null) {
            value = loader.getProperty(key);
            map.put(key, value != null ? value : "");
        }
        return value;
    }

    public static String getAdminPath() {
        return Global.getConfig("adminPath");
    }

    public static String getFrontPath() {
        return Global.getConfig("frontPath");
    }

    public static String getUrlSuffix() {
        return Global.getConfig("urlSuffix");
    }

    public static Boolean isDemoMode() {
        String dm = Global.getConfig("demoMode");
        return TRUE.equals(dm) || "1".equals(dm);
    }

    public static Boolean isDevMode() {
        String dm = Global.getConfig("mode");
        return !"product".equals(dm);
    }

    public static Boolean isProductMode() {
        return Global.isDevMode() == false;
    }

    public static Boolean isSynActivitiIndetity() {
        String dm = Global.getConfig("activiti.isSynActivitiIndetity");
        return TRUE.equals(dm) || "1".equals(dm);
    }

    public static Object getConst(String field) {
        try {
            return Global.class.getField(field).get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getProjectPath() {
        String projectPath = Global.getConfig("projectPath");
        if (StringUtils.isNotBlank((String)projectPath)) {
            return projectPath;
        }
        try {
            File file = new DefaultResourceLoader().getResource("").getFile();
            if (file != null) {
                File f;
                while ((f = new File(file.getPath() + File.separator + "src" + File.separator + "main")) != null && !f.exists() && file.getParentFile() != null) {
                    file = file.getParentFile();
                }
                projectPath = file.toString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return projectPath;
    }
}

