<%@ page language="java" contentType="text/html;charset=UTF-8" %> 
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap/css/bootstrap.min.css">
	<link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap/css/bootstrap-theme.min.css">
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/bootstrap/js/bootstrap.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/layer/layer.js"> </script>
    <link rel="stylesheet" href="<%=request.getContextPath() %>/js/jquery-uploadify/css/uploadify.css">
	<script src="<%=request.getContextPath() %>/js/jquery-uploadify/jquery.uploadify.min.js" type="text/javascript"></script>
	<script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/jquery.twbsPagination/jquery.twbsPagination.js"></script>
</head>
<body>
<div class="container-fluid">
	<%--show modal start--%>
<div class="modal fade" id="myImageModal" tabindex="-1" role="dialog" aria-labelledby="myImageModalLabel" aria-hidden="true">
   <div class="modal-dialog">
      <div class="modal-content">
         <div class="modal-header">
            <button type="button" class="close" 
               data-dismiss="modal" aria-hidden="true">
                  &times;
            </button>
            <h4 class="modal-title" id="myImageModalLabel">
               	图片列表
            </h4>
         </div>
         <div class="modal-body">
 			<div class="list-group" id="showImageList">
			  
			</div>
		    <div>
            	<span id="myImage" role="button" class="btn"></span>
            </div>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-default" onclick="closeModal()">关闭
            </button>
         </div>
      </div>
     </div> 
</div>
		<%--show modal end--%>
		<div class="col-md-3" style="padding: 0px;">
			<div class="panel panel-default" style="margin-bottom: 0px;">
				<div class="panel-heading">
					<h3 class="panel-title" style="text-align: center;">选择模块</h3>
				</div>
				<div class="panel-body">
					<!-- Single button -->
					<div class="btn-group" role="group" aria-label="First group">
						<span type="button" id="ckuMatch" onclick="changeTable('ckuMatch')" class="btn btn-info">赛事</span>
						<span type="button" id="gameTimeTab" onclick="changeTable('gameTimeTab')" class="btn btn-default">赛事时间表</span>
						<span type="button" id="ckuTopMatch" onclick="changeTable('ckuTopMatch')" class="btn btn-default">推荐赛事配图</span>
						<span type="button" id="ckuMatchHotel" onclick="changeTable('ckuMatchHotel')" class="btn btn-default">赛事酒店</span>
				    </div><br>
					<div class="btn-group" role="group" aria-label="Second group">
						<span type="button" id="ckuMatchVenue" onclick="changeTable('ckuMatchVenue')" class="btn btn-default">赛事场馆</span>
						<span type="button" id="ckuDogClass" onclick="changeTable('ckuDogClass')" class="btn btn-default">犬只种类</span>
						<span type="button" id="ckuCaiPan" onclick="changeTable('ckuCaiPan')" class="btn btn-default">赛事裁判</span>
				    </div>
					<!-- <div class="btn-group">
						<span type="button" class="btn btn-default">赛事</span>
						<span type="button" class="btn btn-default">赛事时间表</span>
						<span type="button" class="btn btn-default">推荐赛事配图</span>
						<span type="button" class="btn btn-default">赛事酒店</span>
						<span type="button" class="btn btn-default">赛事场馆</span>
						<span type="button" class="btn btn-default">犬只种类</span>
						<span type="button" class="btn btn-default">赛事裁判</span>
						<button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" id="showTableName" aria-expanded="false">
							赛事 <span class="caret"></span>
						</button>
						<ul class="dropdown-menu">
							<li><a id="ckuMatch" onclick="changeTable('ckuMatch')">赛事</a></li>
							<li><a id="ckuMatchHotel" onclick="changeTable('ckuMatchHotel')">赛事酒店</a></li>
							<li><a id="ckuMatchVenue" onclick="changeTable('ckuMatchVenue')">赛事场馆</a></li>
							<li><a id="ckuDogClass" onclick="changeTable('ckuDogClass')">犬只种类</a></li>
							<li><a id="ckuCaiPan" onclick="changeTable('ckuCaiPan')">裁判</a></li>
							<li><a id="gameTimeTab" onclick="changeTable('gameTimeTab')">赛事时间表</a></li>
							<li><a id="ckuTopMatch" onclick="changeTable('ckuTopMatch')">推荐赛事配图</a></li>
						</ul>
					</div> -->
					<div class="input-group">
						<span class="input-group-addon" id="basic-addon1">名称</span>
						<input type="text" class="form-control" id="keyword" placeholder="名称" aria-describedby="basic-addon1">
						<span class="input-group-addon" onclick="resend()">发送</span>
					</div>
				</div>
			</div>
		</div>
		<div class="col-md-9" style="padding: 0px;">
			<div class="panel panel-default" style="margin-bottom: 0px;">
				<div class="panel-heading">
					<h3 class="panel-title" style="text-align: center;">列表</h3>
				</div>
				<div class="panel-body">
					<table class="table">
						<thead>
						<tr>
							<th>ID</th>
							<th>名称</th>
							<th>配图</th>
							<th>操作</th>
						</tr>
						</thead>
						<tbody id="showcontent">

						</tbody>
					</table>

					<%--分页--%>
					<nav id="pagination_box"><ul class="pagination" id="pagercontent"></ul></nav>
					<span id="pageval" style="display:none;">1</span>
					<span id="pagetotal" style="display:none;">0</span>
				</div>
			</div>
</div>
<script>
	var globalTable = "ckuMatch";
	var globalUpdateId;
	send();
    $('#myImage').uploadify({
		'swf'      : '../js/jquery-uploadify/uploadify.swf',
		'uploader' : 'saveLocalImage.do',
		'height': 25,
		'width' :100,
		'auto'  : true,
		'fileObjName' : 'file',   //文件对象名称,用于后台获取文件对象时使用
		'buttonText' : '选择',
		'fileTypeExts' : '*.gif; *.jpg; *.png',
		'multi'    : true,
		'method'   :'post',
		'debug':false,
		'onInit': function () {     //载入时触发，将flash设置到最小
			//$("#myImage").hide();
			//$("#myImage-queue").hide();
		},
		'onUploadStart' : function(file) {
            var param = {};
            param.type = globalTable;
            param.typeId = globalUpdateId;
            $("#myImage").uploadify("settings", "formData", param);
		},
		'onUploadSuccess' : function(file, data, response) {
			console.log(data);
			console.log(typeof data);
			var json = eval("(" + data + ")");
			//{"state": "SUCCESS","original": "cq3.png","title": "27_6_1458811079263.jpg","type": ".png","url": "http://chongaibao.b0.upaiyun.com/cab_test/image/image/27_6_1458811079263.jpg"}
			 if(json.rc ==0){
				 var item = json.items;
				$("#showImageList").append("<a class=\"list-group-item\" id=\"showImageId"+item.imageId+"\"><span class=\"badge\" onclick=\"delImg("+item.imageId+")\">删除</span><img style=\"width: 500px;height:200px;\" src=\""+item.imageMaxUrl+"\" alt=\""+item.imageId+"\"/></a>");
			} 
		},
		'onUploadError' : function(file, errorCode, errorMsg, errorString) {
			alert('The file ' + file.name + ' could not be uploaded: ' + errorString);
		}

	});
	function changeTable(val){
		globalTable = val;
		//$("#showTableName").html($("#"+val).html()+"<span class=\"caret\"></span>");
		$(".btn-group span").attr("class","btn btn-default");
		$("#"+val).removeClass("btn-default").addClass("btn-info");
		resend();
	}
	//重新发送请求
	function resend(){
		$("#pageval").html(1);
		send();
	}
	//发送请求
	function send(){
		var keyword = $("#keyword").val();
		var page = $("#pageval").html();
		$.ajax({
			type:"get",
			url:"list.do",
			data:{keyword:keyword,table:globalTable,page:page,limit:10},
 			dataType: 'json',
	        timeout: 30000,
	        success: function(json){
	        	console.log(json);
	        	buildHtml(page,json)
	        },
	        error: function(xhr, type){
	            
	        }
		});
	}
	//重构页面
	function buildHtml(page,json){
		$("#showcontent").html("");
		if(json.rc==0){
			var list = json.items;
			if(list.length>0){
				var html = "";
				$.each(list, function(index,item) {
					html+="<tr><td>"+item.id+"</td><td>"+item.name+"</td><td>"+item.imageCount+"</td><td><button type=\"button\" class=\"btn btn-default\" onclick=\"showModal('"+item.id+"')\">修改</button></td></tr>";
				});
				$("#showcontent").html(html);
			}else{
				$("#showcontent").html("没有数据");
			}
			//分页代码
			var page_size = $("#pagetotal").html();
			page_size = parseInt(page_size);
			if(page_size!=json.total){
				$("#pagination_box").html('<ul id="pagercontent" class="pagination"></ul>');
			}
			$('#pagercontent').twbsPagination({
				startPage: page,
				initiateStartPageClick: false,
				totalPages: json.total==0?1:Math.ceil(json.total/10),
				onPageClick: function (event, page) {
					$('#pageval').html(page);
					send();
				}
			});
			$("#pagetotal").html(json.total);

		}else{
			$("#showcontent").html("请求出错！");
		}
		
	}
	function showModal(id){
		$("#showImageList").html("");
		globalUpdateId = id;
		$.ajax({
			type:"get",
			url:"getImage.do",
			data:{id:id,table:globalTable},
 			dataType: 'json',
	        timeout: 30000,
	        success: function(json){
	    		if(json.rc==0){
	    			var list = json.items;
	    			if(list.length>0){
	    				var html = "";
		    			$.each(list, function(index,item) {
		    				html+="<a class=\"list-group-item\" id=\"showImageId"+item.imageId+"\"><span class=\"badge\" onclick=\"delImg("+item.imageId+")\">删除</span><img style=\"width: 500px;height:200px;\" src=\""+item.imageMinUrl+"\" alt=\""+item.imageId+"\"/></a>";
		    			});
		    			$("#showImageList").html(html);
	    			}

	    			
	    		}else{
	    			$("#showImageList").html("请求出错！");
	    		}
	        },
	        error: function(xhr, type){
	            
	        }
		});
		$('#myImageModal').modal('show');
	}
	function closeModal(){
		$('#myImageModal').modal('hide');
		send();
	}
	function delImg(id){
		$.ajax({
			type:"get",
			url:"delImage.do",
			data:{id:id},
 			dataType: 'json',
	        timeout: 30000,
	        success: function(json){
	    		if(json.rc==0){
	    			$("#showImageId"+id).remove();
	    		}else{
	    			$("#showImageList").html("请求出错！");
	    		}
	        },
	        error: function(xhr, type){
	            
	        }
		});
	}
</script>
</body>
</html>
