package com.sys.model;

import java.util.*;

import net.sf.json.JSONObject;

public class Token
{
	private String _tokenStr;
	private long _userId;
	private String _loginType;
	
	private Map<String, String> _infoMap;

	public Token(long userId, String tokenStr, String loginType)
	{
		this.set_tokenStr(tokenStr);
		this.set_userId(userId);
		this.set_loginType(loginType);
	}
	
	public void put(String key, String val)
	{
		if (this.get_infoMap() == null)
		{
			this.set_infoMap(new TreeMap<String, String>());
		}
		
		this.get_infoMap().put(key, val);
	}
	
	public long get_userId() {
		return _userId;
	}

	public void set_userId(long _userId) {
		this._userId = _userId;
	}

	public String get_tokenStr() {
		return _tokenStr;
	}

	public void set_tokenStr(String _tokenStr) {
		this._tokenStr = _tokenStr;
	}

	public Map<String, String> get_infoMap() {
		return _infoMap;
	}

	public void set_infoMap(Map<String, String> _infoMap) {
		this._infoMap = _infoMap;
	}
	
	
	
	public String get_loginType() {
		return _loginType;
	}

	public void set_loginType(String _loginType) {
		this._loginType = _loginType;
	}

	public JSONObject toJSON()
	{
		JSONObject jo = new JSONObject();
		jo.put("userId", this._userId);
		
		if (this._infoMap != null)
		{
			JSONObject joMap = new JSONObject();
			joMap.putAll(this._infoMap);
			jo.put("props", joMap);
		}
		
		return jo;
	}
}
