package com.cku.controller;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.model.CkuMatchRule;
import com.cku.service.CkuMatchRuleServiceImpl;
import com.cku.util.PageBean;
import com.cku.util.ServletUtils;

@Controller
@RequestMapping(value="ckuMatchRule")
public class CkuMatchRuleController {
	private static final Logger logger = Logger.getLogger(CkuMatchRuleController.class);
	@Autowired
	public CkuMatchRuleServiceImpl ckuMatchRuleService;
	
	//得到所有接口
	@RequestMapping(value="/getAll")
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void getAll(HttpServletResponse response,HttpServletRequest request) {
		try {
			System.out.println("test--------------");
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String result = ckuMatchRuleService.getAll();
		    response.getWriter().write(result);
		} catch (Exception e) {
			// TODO: handle exception
			logger.error(e);
		}
	}
	//得到所有接口
	@RequestMapping(value="/getRuleById")
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void getRuleById(@RequestParam(value = "id", required = false)Long id,
			HttpServletResponse response,HttpServletRequest request) {
		try {
			System.out.println("test--------------");
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String result = ckuMatchRuleService.getRuleById(id);
		    response.getWriter().write(result);
		} catch (Exception e) {
			// TODO: handle exception
			logger.error(e);
		}
	}
	
	//得到ModalList
	@RequestMapping(value="/getListModal")
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void getListModal(HttpServletResponse response,HttpServletRequest request) throws IOException {
		RESTResponse result = null;
		try{
			String name = ServletUtils.getParameter(request, "name",null);
			PageBean pb = ServletUtils.getParameterBean(request);
			PageBeanResult<CkuMatchRule> list = ckuMatchRuleService.getList(name,null,pb);
			result = new RESTResponse("items", list);
		}catch (Exception e){
			result = new RESTResponse(e);
			logger.error(e);
		}
		ServletUtils.writeResponse(response, result);

	}
	/**
	 * 
	 */
	@RequestMapping(value="/getList")
	public ModelAndView getList(HttpServletResponse response,HttpServletRequest request,ModelMap modelMap) throws IOException {
		String ruleName = ServletUtils.getParameter(request, "ruleName",null);
		String ruleInfo = ServletUtils.getParameter(request, "ruleInfo",null);
		PageBean pb = ServletUtils.getParameterBean(request);
		PageBeanResult<CkuMatchRule> s = ckuMatchRuleService.getList(ruleName,ruleInfo,pb);
		modelMap.addAttribute("pageList",s);
		ModelAndView mv = new ModelAndView("admin/ckuMatchRule/matchRuleList",modelMap);
		return mv;
	}
	/**
	 * 跳转修改页面
	 */
	@RequestMapping(value="/toUpdate")
	public ModelAndView toUpdate(HttpServletResponse response,HttpServletRequest request, ModelMap modelMap) throws IOException{
		String type = ServletUtils.getParameter(request, "type","add");
		//如果传递的参数是edit则执行修改操作否则执行添加操作
		if("edit".equals(type)){
			Long id = ServletUtils.getParameterLong(request, "id", null);
			CkuMatchRule cmr = ckuMatchRuleService.selectByPrimaryKey(id);
			modelMap.addAttribute("matchRule",cmr);
		}else{
			modelMap.addAttribute("matchRule",null);
		}
		ModelAndView mv = new ModelAndView("admin/ckuMatchRule/updateMatchRule",modelMap);
		return mv;
	}
	/**
	 * 添加赛事规则
	 */
	@RequestMapping(value="/addMatchRule")
	public ModelAndView addMatchRule(HttpServletResponse response,HttpServletRequest request,CkuMatchRule ckuMatchRule, ModelMap modelMap)throws IOException{
		//添加条数
		int i = ckuMatchRuleService.insertSelective(ckuMatchRule);
		String result = i>0?"success":"error";
		modelMap.addAttribute("toPage","ckuMatchRule/getList.do");
		modelMap.addAttribute("message",i>0?"添加赛事规则成功!":"添加赛事规则失败!");
		ModelAndView mv = new ModelAndView(result,modelMap);
		return mv;
	}
	/**
	 * 修改赛事规则
	 */
	@RequestMapping(value="/updateMatchRule")
	public ModelAndView updateMatchRule(HttpServletResponse response,HttpServletRequest request,CkuMatchRule ckuMatchRule, ModelMap modelMap)throws IOException{
		//修改条数
		int i = ckuMatchRuleService.updateByPrimaryKeySelective(ckuMatchRule);
		String result = i>0?"success":"error";
		modelMap.addAttribute("toPage","ckuMatchRule/getList.do");
		modelMap.addAttribute("message",i>0?"修改赛事规则成功!":"修改赛事规则失败!");
		ModelAndView mv = new ModelAndView(result,modelMap);
		return mv;
	}
	/**
	 * 删除赛事规则
	 */
	@RequestMapping(value="/deleteMatchRule")
	@ResponseBody
	public void deleteMatchRule(HttpServletResponse response,HttpServletRequest request)throws IOException{
		RESTResponse result = null;
		try{
			long id = ServletUtils.getParameterLong(request, "id",null);
			int i = ckuMatchRuleService.deleteByPrimaryKey(id);
			if(i>0){
				result = new RESTResponse(0,"删除赛事规则成功！");
			}else{
				result = new RESTResponse(1,"删除赛事规则失败！");
			}
		}catch (Exception e){
			result = new RESTResponse(e);
			logger.error(e);
		}
		ServletUtils.writeResponse(response, result);
	}
}





















