package com.cab.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cab.dao.CabSysUserMapper;
import com.cab.dao.PointsDetailMapper;
import com.cab.dao.PointsTypeMapper;
import com.cab.model.CabSysUser;
import com.cab.model.PointsDetail;
import com.cab.model.PointsType;

@Service("utilServiceImpl")
public class UtilServiceImpl {
	
	@Autowired
	private PointsTypeMapper pointsTypeMapper;
	@Autowired
	private PointsDetailMapper pointsDetailMapper;
	@Autowired
	public CabSysUserMapper cabSysUserMapper;
	
	/**
	 * 
	 * @Description：根据积分类型查询积分信息
	 * @author: zhuoHeng
	 * @version: 2016年6月20日 上午11:14:11
	 */
	public PointsType getPointsType(Integer type){
		return pointsTypeMapper.selectByType(type);
	}
	
	/**
	 * 
	 * @Description：增加积分明细信息
	 * @author: zhuoHeng
	 * @version: 2016年6月20日 上午11:22:07
	 */
	public void addPointsDetail(PointsDetail pointsDetail){
		pointsDetailMapper.insertSelective(pointsDetail);
	}
	
	/**
	 * 
	 * @Description：每日登录增加积分
	 * @author: zhuoHeng
	 * @version: 2016年6月21日 下午1:38:51
	 */
	public void addPointsForLogin(CabSysUser user){
		CabSysUser u = new CabSysUser();
		SimpleDateFormat time = new SimpleDateFormat("yyyyMMdd");
		if(user.getLastLogin()!=null){
			Date lastLogin = user.getLastLogin();
			String loginDate = time.format(lastLogin);
			if(!time.format(new Date()).equals(loginDate)){
				PointsType pointsType = getPointsType(1);
				u.setId(user.getId());
				//总积分累加
				u.setPoints(user.getPoints()+pointsType.getPoints());
				cabSysUserMapper.updateByPrimaryKeySelective(u);
				//积分明细增加一条数据
				PointsDetail pointsDetail = new PointsDetail();
				pointsDetail.setType(pointsType.getType());
				pointsDetail.setPoints(pointsType.getPoints());
				pointsDetail.setRemarks(pointsType.getRemarks());
				pointsDetail.setCreateTime(new Date());
				pointsDetail.setCreateUser(user.getId());
				addPointsDetail(pointsDetail);
			}
		}else{
			PointsType pointsType = getPointsType(1);
			u.setId(user.getId());
			//总积分累加
			u.setPoints(user.getPoints()==null?0:user.getPoints()+pointsType.getPoints());
			cabSysUserMapper.updateByPrimaryKeySelective(u);
			//积分明细增加一条数据
			PointsDetail pointsDetail = new PointsDetail();
			pointsDetail.setType(pointsType.getType());
			pointsDetail.setPoints(pointsType.getPoints());
			pointsDetail.setRemarks(pointsType.getRemarks());
			pointsDetail.setCreateTime(new Date());
			pointsDetail.setCreateUser(user.getId());
			addPointsDetail(pointsDetail);
		}
		u.setId(user.getId());
		u.setLastLogin(new Date());
		cabSysUserMapper.updateByPrimaryKeySelective(u);
	}
	
	/**
	 * 
	 * @Description：根据积分类型增加用户积分支持方法
	 * @author: zhuoHeng
	 * @version: 2016年6月21日 下午3:49:46
	 */
	public void addPoints(String userId,Integer type){
		
		List<PointsDetail> list = pointsDetailMapper.getPointsDetail(userId,type,null,null);
		PointsType pointsType = getPointsType(type);
		//判断当前用户分享数是否达到每日上限
		if(pointsType!=null && (list.size()==0 || pointsType.getCount()>list.get(0).getTotal())){
			//根据用户id查询出cab用户信息
			CabSysUser user = cabSysUserMapper.selectByPrimaryId(userId);
			CabSysUser u = new CabSysUser();
			u.setId(user.getId());
			//累加当前用户的总积分
			u.setPoints(user.getPoints()==null?0:user.getPoints()+pointsType.getPoints());
			cabSysUserMapper.updateByPrimaryKeySelective(u);
			//积分明细增加一条数据
			PointsDetail pointsDetail = new PointsDetail();
			pointsDetail.setType(pointsType.getType());
			pointsDetail.setPoints(pointsType.getPoints());
			pointsDetail.setRemarks(pointsType.getRemarks());
			pointsDetail.setCreateTime(new Date());
			pointsDetail.setCreateUser(user.getId());
			addPointsDetail(pointsDetail);
		}
	}

}
