/*
 * Decompiled with CFR 0.152.
 */
package com.antherd.smcrypto.sm4;

import com.antherd.smcrypto.sm4.Sm4Options;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class Sm4 {
    private static Invocable invocable = null;

    public static String encrypt(String msg, String key, Sm4Options sm4Options) {
        if (msg == null || msg.trim().isEmpty()) {
            return "";
        }
        String encryptData = null;
        try {
            encryptData = (String)invocable.invokeFunction("encrypt", msg, key, Sm4.getOptionsMap(sm4Options));
        }
        catch (NoSuchMethodException | ScriptException e) {
            e.printStackTrace();
        }
        return encryptData;
    }

    public static String encrypt(String msg, String key) {
        return Sm4.encrypt(msg, key, null);
    }

    public static String decrypt(String encryptData, String key, Sm4Options sm4Options) {
        if (encryptData == null || encryptData.trim().isEmpty()) {
            return "";
        }
        String decryptData = null;
        try {
            decryptData = (String)invocable.invokeFunction("decrypt", encryptData, key, Sm4.getOptionsMap(sm4Options));
        }
        catch (NoSuchMethodException | ScriptException e) {
            e.printStackTrace();
        }
        return decryptData;
    }

    public static String decrypt(String encryptData, String key) {
        return Sm4.decrypt(encryptData, key, null);
    }

    public static byte[] hexToBytes(String hex) {
        byte[] result;
        int length = hex.length();
        if (length % 2 == 1) {
            result = new byte[++length / 2];
            hex = "0" + hex;
        } else {
            result = new byte[length / 2];
        }
        int j = 0;
        for (int i = 0; i < length; i += 2) {
            result[j] = Sm4.hexToByte(hex.substring(i, i + 2));
            ++j;
        }
        return result;
    }

    private static byte hexToByte(String hex) {
        return (byte)Integer.parseInt(hex, 16);
    }

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(aByte & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static byte[] utf8ToArray(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static String arrayToUtf8(byte[] arr) {
        return new String(arr, StandardCharsets.UTF_8);
    }

    private static Map<String, Object> getOptionsMap(Sm4Options sm4Options) {
        String iv;
        String mode;
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (sm4Options == null) {
            return options;
        }
        String padding = sm4Options.getPadding();
        if (padding != null && !padding.trim().equals("")) {
            options.put("padding", padding);
        }
        if ((mode = sm4Options.getMode()) != null && !mode.trim().equals("")) {
            options.put("mode", mode);
        }
        if ((iv = sm4Options.getIv()) != null && !iv.trim().equals("")) {
            options.put("iv", iv);
        }
        return options;
    }

    static {
        try {
            InputStream inputStream = Sm4.class.getClassLoader().getResourceAsStream("sm4.js");
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
            engine.eval(new BufferedReader(new InputStreamReader(inputStream)));
            invocable = (Invocable)((Object)engine);
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }
}

