/*
 * Decompiled with CFR 0.152.
 */
package com.cku.util;

import com.cku.core.RetryException;
import com.cku.util.Debugger;
import com.cku.util.IRetryFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryUtils {
    public static <T> T CallWithRetry(IRetryFunction<Object[], T> f, int times, Object ... params) throws Exception {
        Debugger.doAssert(times > 0, -9, "Invalid retry call", new Object[0]);
        Exception lastException = null;
        for (int current = 0; current < times; ++current) {
            try {
                T result = f.execute(params);
                return result;
            }
            catch (Exception e) {
                if (e instanceof RetryException) {
                    RetryException r = (RetryException)e;
                    lastException = r.getException();
                    continue;
                }
                throw e;
            }
        }
        throw lastException;
    }
}

