package com.cku.service;

import cn.jpush.api.JPushClient;
import cn.jpush.api.common.resp.APIConnectionException;
import cn.jpush.api.common.resp.APIRequestException;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.Notification;

public class PushExample {
    
    static JPushClient jpushClient = new JPushClient("cef50f2cf31806b734a17cb9", "6d03e1e2158f4377af7fd772");
    
    public static void push_all_message(String message){
            PushPayload payload = buildPushObject_all_message(message);
            try {
                PushResult result = jpushClient.sendPush(payload);
                System.out.println("result1"+result);
            } catch (APIConnectionException e) {
                e.printStackTrace();
            } catch (APIRequestException e) {
                e.printStackTrace();
            }
        }

        public static void push_alias_message(String alias,String message){
            PushPayload payload = buildPushObject_alias_message(alias,message);
            try {
                jpushClient.sendPush(payload);
            } catch (APIConnectionException e) {
                e.printStackTrace();
            } catch (APIRequestException e) {
                e.printStackTrace();
            }
        }

        public static PushPayload buildPushObject_all_message(String message) {
            return PushPayload.alertAll(message);
        }

        public static PushPayload buildPushObject_alias_message(String alias,String message) {
            return PushPayload.newBuilder()
            .setPlatform(Platform.all())
            .setAudience(Audience.alias(alias))
            .setNotification(Notification.alert(message))
            .build();
    
        }
        
        public static void main(String[] args) {
            push_all_message("test20160711");
        }
}
