package com.cku.controller;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cku.service.CkuMyMatchServiceImpl;

@Controller
@RequestMapping(value="my")
public class CkuMyMatchController {
	
	private static final Logger logger = Logger.getLogger(CkuMyMatchController.class);
	
	@Autowired
	private CkuMyMatchServiceImpl ckuMyMatchServiceImpl;
	/**
	 * 
	 * @Description：根据登录用户会员号获取个人中心-我的赛事（近期赛事）和赛事下参加的犬只列表
	 * @author: zhuoHeng
	 * @version: 2016年4月2日 上午11:23:43
	 */
	@RequestMapping(value = "/getMyMatch")
	public void getMyMatchByLoginUser (HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "page", required = false)Integer page,
			@RequestParam(value = "limit", required = false)Integer limit,
			@RequestParam(value = "idNum", required = false)String idNum)throws IOException {
		try {
			String flag = "There";
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = ckuMyMatchServiceImpl.getMyMatchByLoginUser(page,limit,idNum,flag,null);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
	/**
	 * 
	 * @Description：根据登录用户会员号获取个人中心-我的赛事（历史赛事）和赛事下参加的犬只列表
	 * @author: zhuoHeng
	 * @version: 2016年4月2日 下午3:04:29
	 */
	@RequestMapping(value = "/getMyMatchHD")
	public void getMyMatchHDByLoginUser (HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "page", required = false)Integer page,
			@RequestParam(value = "limit", required = false)Integer limit,
			@RequestParam(value = "idNum", required = false)String idNum,
			@RequestParam(value = "hrstime", required = false)String hrstime)throws IOException {
		try {
			String flag ="History";
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = ckuMyMatchServiceImpl.getMyMatchByLoginUser(page,limit,idNum,flag,hrstime);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		
	}
	/**
	 * 
	 * @Description：根据赛事编号和犬只CKU血统证书号查询犬只报名信息（包含场次明细和比赛成绩和牵犬师信息）
	 * @author: zhuoHeng
	 * @version: 2016年4月2日 下午12:57:24
	 */
	@RequestMapping(value = "/getSignByStudbookNum")
	public void getSignByStudbookNum (HttpServletResponse response,HttpServletRequest request,
			@RequestParam(value = "showNum", required = false)String showNum,
			@RequestParam(value = "studbookNum", required = false)String studbookNum)throws IOException {
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str = ckuMyMatchServiceImpl.getSignByStudbookNum(showNum,studbookNum);
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		
	}
	

}
