package com.cku.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.cku.core.BaseDAOMapper;
import com.cku.core.BaseService;
import com.cku.core.ExecResultModel;
import com.cku.core.PageBeanResult;
import com.cku.dao.CkuImageMapper;
import com.cku.dao.CkuMatchVenueMapper;
import com.cku.model.CkuImage;
import com.cku.model.CkuMatchVenue;
import com.cku.util.HttpClientUtil;
import com.cku.util.HttpResult;
import com.cku.util.PageBean;
import com.cku.util.SysConfig;

@Service("ckuMatchVenueSerivce")
public class CkuMatchVenueServiceImpl  extends BaseService<CkuMatchVenue>{
	@Autowired
	public CkuMatchVenueMapper ckuMatchVenueMapper;
	
	@Autowired
	public CkuImageMapper ckuImageMapper;
	@Override
	protected BaseDAOMapper<CkuMatchVenue> getDAO() {
		return this.ckuMatchVenueMapper;
	}
	public String getVenue(String showLocation){
		ExecResultModel<CkuMatchVenue> resultModel = new ExecResultModel<CkuMatchVenue>();
		List<CkuMatchVenue> list = new ArrayList<CkuMatchVenue>();
		CkuMatchVenue ckuMatchVenue = ckuMatchVenueMapper.getVenue(showLocation);
		if(ckuMatchVenue==null){
			resultModel.setItems(new ArrayList<CkuMatchVenue>());
			resultModel.setTotal((long) list.size());
			resultModel.setRc(0);
			resultModel.setMsg("无对应数据");
		}else{
			list.add(ckuMatchVenue);
			resultModel.setItems(list);
			resultModel.setTotal((long) list.size());
			resultModel.setRc(0);
			resultModel.setMsg("");
		}
		
		return resultModel.getToJson();
	}
	public PageBeanResult<CkuMatchVenue> getList(String name,String address,PageBean pb){
		PageBeanResult<CkuMatchVenue> pbr = new PageBeanResult<CkuMatchVenue>();
		List<CkuMatchVenue> list = ckuMatchVenueMapper.getList(name,address,pb.get_limit(),pb.get_start());
		pbr.list = list;
		pbr.totalCount = ckuMatchVenueMapper.getCount(name,address);
		return pbr;
	}
	public int addMatchVenue(CkuMatchVenue ckuMatchVenue) throws IOException {
		Map<String, String> map = new HashMap<String, String>();
		map.put("address", ckuMatchVenue.getVenueAddress().replaceAll(" ", ""));
		map.put("output", "json");
		map.put("ak", SysConfig.getInstance().getProperty("ak"));
		HttpResult httpResult = HttpClientUtil.get(null, SysConfig.getInstance().getProperty("baidulatlngurl"), map);
		String repb = httpResult.getResponseBody();
		JSONObject obj = JSONObject.parseObject(repb);
		if(obj.getInteger("status").intValue()==0){
			String lng = obj.getJSONObject("result").getJSONObject("location").getString("lng");
			String lat = obj.getJSONObject("result").getJSONObject("location").getString("lat");
			ckuMatchVenue.setVenueLatitude(lat);
			ckuMatchVenue.setVenueLongitude(lng);
		}
		ckuMatchVenue.setCreateTime(new Date());
		return ckuMatchVenueMapper.insertSelective(ckuMatchVenue);
	}
	public int updateVenue(CkuMatchVenue ckuMatchVenue)throws IOException {
		Map<String, String> map = new HashMap<String, String>();
		map.put("address", ckuMatchVenue.getVenueAddress().replaceAll(" ", ""));
		map.put("output", "json");
		map.put("ak", SysConfig.getInstance().getProperty("ak"));
		HttpResult httpResult = HttpClientUtil.get(null, SysConfig.getInstance().getProperty("baidulatlngurl"), map);
		String repb = httpResult.getResponseBody();
		JSONObject obj = JSONObject.parseObject(repb);
		if(obj.getInteger("status").intValue()==0){
			String lng = obj.getJSONObject("result").getJSONObject("location").getString("lng");
			String lat = obj.getJSONObject("result").getJSONObject("location").getString("lat");
			ckuMatchVenue.setVenueLatitude(lat);
			ckuMatchVenue.setVenueLongitude(lng);
		}
		ckuMatchVenue.setCreateTime(new Date());
		return ckuMatchVenueMapper.updateByPrimaryKeySelective(ckuMatchVenue);
	}
	//查询场馆的配图
	public List<CkuImage> selectImageById(long id) {
		List<CkuImage> list=ckuImageMapper.getVenueImage(id);
		return list;
	}
	//查询场馆信息 不包含图片
	public CkuMatchVenue selectVenueById(long id) {
		CkuMatchVenue cmv=ckuMatchVenueMapper.selectVenueById(id);
		return cmv;
	}
}
