package com.cab.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cab.dao.CabMymessageMapper;
import com.cab.dao.ContentMapper;
import com.cab.model.MyMessageCount;
import com.cku.dao.CkuDvUserMapper;
import com.cku.dao.CkuMyMatchMapper;
import com.cku.dao.SPOrderInfoMapper;
import com.cku.model.CkuDvUserModel;
import com.cku.service.OrderServiceImpl;
import com.cku.util.PageBean;
import com.sys.model.MultiUserProfile;

/**
 *user chaixueteng
 *2016年5月3日
 */
@Service("MyMessageCountService")
public class MyMessageCountServiceImpl {
	@Autowired
	public CkuDvUserMapper ckuDvUserMapper;
	@Autowired
	public CkuMyMatchMapper ckuMyMatchMapper;
	@Autowired
	public CabMymessageMapper cabMymessageMapper;
	@Autowired
	public SPOrderInfoMapper spOrderInfoMapper;
	@Autowired
	public ContentMapper contentMapper;
	@Autowired
	public OrderServiceImpl  orderServiceImpl;
	@Autowired
	public SPOrderInfoMapper sPOrderInfoMapper;
	
	
	public MyMessageCount getMessageCount(MultiUserProfile userProfile,PageBean pb) {
		MyMessageCount myMessageCount = new MyMessageCount();
		//得到未读消息总数
		long mymessageCountByRead = cabMymessageMapper.getMymessageCountByRead(userProfile.getUserId());
		myMessageCount.setMyMessageCount(mymessageCountByRead);
		String ckuId = "-1";
		//根据CKU账号id查询出CKU账号信息
		CkuDvUserModel ckuDvUserModel = ckuDvUserMapper.getckuMemberByUserId(userProfile.getCurrentClubUserId());
		if(ckuDvUserModel != null){
			ckuId = ckuDvUserModel.getCkuId();
		}
		//根据会员号和支付状态得到未支付的订单数
		// ---- 修改了查询未支付订单的方法 by zhuoHeng ----
//		long unPayOrderCount = orderServiceImpl.getOrderListNew(new Long(userId).intValue(),"0",pb).getTotalCount();
		int unPayOrderCount=sPOrderInfoMapper.checkSignUnfinished(ckuId);
		// ---- end ----
		
		//得到已支付的订单数
		// ---- APP端不需要此计数的显示 by zhuoHeng ----
//		long payOrderCount=orderServiceImpl.getOrderListNew(new Long(userId).intValue(),"1",pb).getTotalCount();
//		myMessageCount.setMyOrderPayCount(payOrderCount);
		// ---- end ----
		
		// ---- 新增购物车数量 by zhuoHeng
		int paymentCartCount=sPOrderInfoMapper.countPaymentCart(ckuId);
		myMessageCount.setMyPaymentCartCount(paymentCartCount);
		myMessageCount.setMyOrderCount(unPayOrderCount);
		// ---- end ----
		//近期赛事查询条数
		String flag="There";
		int myMatchThereCount = ckuMyMatchMapper.getMyMatchByLoginUser(null, null, ckuId, flag, null).size();
		myMessageCount.setMyCkuMatchCount(myMatchThereCount);
		//我的收藏
		long myFavoriteCount = contentMapper.searchFavoriteCount(userProfile.getUserId(),null);
		myMessageCount.setMyFavoriteCount(myFavoriteCount);
		return myMessageCount;
	}
	
}
