/*
 * Decompiled with CFR 0.152.
 */
package com.cku.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.cku.util.SysConfig;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenUtil {
    private static final Logger log = LoggerFactory.getLogger(TokenUtil.class);
    public static final long DEFAULT_TIMEOUT = 2592000000L;
    public static final String ENCODE_HEADER_NAME = "token";
    private static final String ISSUER = TokenUtil.isProductMode() ? "develop" : "devtest";
    private static final String SECRET = "ertyuiopyuiopoppom324klkjhgfghjkl";

    private TokenUtil() {
    }

    public static String createJwt(String subject, long ttlMillis) {
        log.info("=====jwt.token.issuer=====" + ISSUER);
        return JWT.create().withExpiresAt(new Date(System.currentTimeMillis() + ttlMillis)).withIssuedAt(new Date()).withSubject(subject).withIssuer(ISSUER).sign(Algorithm.HMAC256((String)SECRET));
    }

    public static DecodedJWT parseJwt(String token) {
        log.info("=====jwt.token.issuer=====" + ISSUER);
        return JWT.require((Algorithm)Algorithm.HMAC256((String)SECRET)).withIssuer(new String[]{ISSUER}).build().verify(token);
    }

    private static boolean isProductMode() {
        String mode = SysConfig.getInstance().getProperty("mode", "dev");
        log.info("=====is.product.mode=====" + mode + ",issuer" + ("product".equals(mode) ? "develop" : "devtest"));
        return "product".equals(mode);
    }
}

