/*
 * Decompiled with CFR 0.152.
 */
package com.cku.util;

import com.cku.core.CouponDivideEquallyDto;
import com.cku.core.ZAException;
import java.math.BigDecimal;
import java.util.Objects;

public class CouponUtils {
    public static CouponDivideEquallyDto divideEqually(int splitQuantity, BigDecimal totalAmount) {
        if (Objects.isNull(totalAmount) || totalAmount.compareTo(BigDecimal.ZERO) <= 0 || splitQuantity <= 0) {
            throw new ZAException(1001, "\u603b\u91d1\u989d\u548c\u62c6\u5206\u6570\u91cf\u5e94\u5927\u4e8e0");
        }
        BigDecimal divideEquallyAmount = totalAmount.divide(new BigDecimal(splitQuantity), 2, 4);
        BigDecimal remainderAmount = totalAmount.subtract(divideEquallyAmount.multiply(new BigDecimal(splitQuantity - 1)));
        return CouponDivideEquallyDto.builder().divideEquallyAmount(divideEquallyAmount).remainderAmount(remainderAmount).build();
    }
}

