/*
 * Decompiled with CFR 0.152.
 */
package com.cku.format;

import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.springframework.format.Formatter;

public class LocalDateTimeFormatter
implements Formatter<LocalDateTime> {
    private static final DateTimeFormatter df_utc = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS+0800");
    public static final String NORMAL_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public String print(LocalDateTime localDate, Locale locale) {
        return DateTimeFormatter.ofPattern(NORMAL_PATTERN).format(localDate);
    }

    public LocalDateTime parse(String text, Locale locale) throws ParseException {
        if (text.length() > 10 && text.charAt(10) == 'T' && text.endsWith("Z")) {
            return LocalDateTime.parse(text, df_utc).plusHours(8L);
        }
        if (text.length() > 10 && text.charAt(10) == 'T' && text.endsWith("+0800")) {
            return LocalDateTime.parse(text, df).plusHours(8L);
        }
        return LocalDateTime.parse(text, DateTimeFormatter.ofPattern(NORMAL_PATTERN));
    }
}

