/*
 * Decompiled with CFR 0.152.
 */
package com.cku.format;

import com.cku.format.LocalDateTimeFormatter;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.sql.Date;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Objects;

public class LocalDateDeserializer
extends JsonDeserializer<LocalDate> {
    public LocalDate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        LocalDate date = null;
        if (t == JsonToken.VALUE_STRING) {
            String str = jp.getText().trim();
            try {
                date = LocalDate.parse(str);
            }
            catch (Exception e) {
                try {
                    LocalDateTime dateTime = new LocalDateTimeFormatter().parse(str, Locale.CHINA);
                    if (Objects.nonNull(dateTime)) {
                        date = dateTime.toLocalDate();
                    }
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
            }
            return date;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new Date(jp.getLongValue()).toLocalDate();
        }
        throw ctxt.mappingException(this.handledType());
    }
}

