/*
 * Decompiled with CFR 0.152.
 */
package com.cku.core;

import com.cku.core.AbstractResultDto;
import com.drew.lang.annotations.Nullable;
import java.io.Serializable;
import lombok.NonNull;

public final class ResultDto<T extends Serializable>
extends AbstractResultDto {
    private static final long serialVersionUID = 8373473477366135987L;
    @Nullable
    private T data;

    private ResultDto() {
    }

    private ResultDto(int rc, String msg) {
        this.rc = rc;
        this.msg = msg;
    }

    private ResultDto(String msg, T data) {
        this.msg = msg;
        this.data = data;
    }

    private ResultDto(T data) {
        this.data = data;
    }

    public static <T extends Serializable> ResultDto<T> error(int rc, String msg) {
        return new ResultDto<T>(rc, msg);
    }

    public static <T extends Serializable> ResultDto<T> SUCCESSFUL() {
        return new ResultDto<T>();
    }

    public static <T extends Serializable> ResultDto<T> success(@NonNull T data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return new ResultDto<T>(data);
    }

    public static <T extends Serializable> ResultDto<T> success(String msg, @NonNull T data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return new ResultDto<T>(msg, data);
    }

    public <K extends Serializable> ResultDto<K> convertToError() {
        return ResultDto.error(this.rc, this.msg);
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultDto)) {
            return false;
        }
        ResultDto other = (ResultDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ResultDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ResultDto(data=" + this.getData() + ")";
    }
}

