/*
 * Decompiled with CFR 0.152.
 */
package com.cku.core;

import com.cku.core.AbstractResultDto;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public final class PageResultDto<T extends Serializable>
extends AbstractResultDto {
    private static final long serialVersionUID = 9190180036125109133L;
    private List<T> list = Collections.emptyList();
    private Long total;
    private Long totalPage;

    private PageResultDto() {
    }

    private PageResultDto(int rc, String msg) {
        this.rc = rc;
        this.msg = msg;
    }

    public PageResultDto(List<T> data, Long total) {
        this.list = data;
        this.total = total;
    }

    public static <T extends Serializable> PageResultDto<T> error(int rc, String msg) {
        return new PageResultDto<T>(rc, msg);
    }

    public static <T extends Serializable> PageResultDto<T> success(List<T> data, Long totalCount) {
        return new PageResultDto<T>(data, totalCount);
    }

    public static <T extends Serializable> PageResultDto<T> success(List<T> data, Long totalCount, Long totalPage) {
        return new PageResultDto<T>(data, totalCount, totalPage);
    }

    public <K extends Serializable> PageResultDto<K> convertToError() {
        return PageResultDto.error(this.rc, this.msg);
    }

    public PageResultDto(List<T> list, Long total, Long totalPage) {
        this.list = list;
        this.total = total;
        this.totalPage = totalPage;
    }

    public List<T> getList() {
        return this.list;
    }

    public Long getTotal() {
        return this.total;
    }

    public Long getTotalPage() {
        return this.totalPage;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public void setTotalPage(Long totalPage) {
        this.totalPage = totalPage;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResultDto)) {
            return false;
        }
        PageResultDto other = (PageResultDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<T> this$list = this.getList();
        List<T> other$list = other.getList();
        if (this$list == null ? other$list != null : !((Object)this$list).equals(other$list)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Long this$totalPage = this.getTotalPage();
        Long other$totalPage = other.getTotalPage();
        return !(this$totalPage == null ? other$totalPage != null : !((Object)this$totalPage).equals(other$totalPage));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PageResultDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<T> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Long $totalPage = this.getTotalPage();
        result = result * 59 + ($totalPage == null ? 43 : ((Object)$totalPage).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PageResultDto(list=" + this.getList() + ", total=" + this.getTotal() + ", totalPage=" + this.getTotalPage() + ")";
    }
}

