/*
 * Decompiled with CFR 0.152.
 */
package com.cku.format;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class LocalTimeDeserializer
extends JsonDeserializer<LocalTime> {
    private static final String TIME_FORMATTER_PATTERN = "HH:mm:ss";
    private static DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

    public LocalTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            String str = jp.getText().trim();
            return LocalTime.parse(str, TIME_FORMATTER);
        }
        throw ctxt.mappingException(this.handledType());
    }
}

