/*
 * Decompiled with CFR 0.152.
 */
package com.cku.format;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class LocalDateTimeDeserializer
extends JsonDeserializer<LocalDateTime> {
    private static final String DATE_TIME_FORMATTER_MILLI_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String DATE_TIME_FORMATTER_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static DateTimeFormatter DATE_TIME_FORMATTER_MILLI = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public LocalDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText();
            if (StringUtils.isBlank((CharSequence)text)) {
                return null;
            }
            String str = text.trim();
            if (DATE_TIME_FORMATTER_PATTERN.length() == str.length()) {
                str = str.replace("T", " ");
                return LocalDateTime.parse(str, DATE_TIME_FORMATTER);
            }
            if (DATE_TIME_FORMATTER_MILLI_PATTERN.length() == str.length()) {
                str = str.replace("T", " ");
                return LocalDateTime.parse(str, DATE_TIME_FORMATTER_MILLI);
            }
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new Timestamp(jp.getLongValue()).toLocalDateTime();
        }
        throw ctxt.mappingException(this.handledType());
    }
}

