/*
 * Decompiled with CFR 0.152.
 */
package com.cku.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.resourceloading.PlatformResourceBundleLocator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ParamsCheckAspect {
    private static Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ResourceBundleMessageInterpolator((ResourceBundleLocator)new PlatformResourceBundleLocator("validationMessages"))).buildValidatorFactory().getValidator();

    @Pointcut(value="@annotation(org.springframework.validation.annotation.Validated))")
    private void validateMethod() {
    }

    @Before(value="validateMethod()")
    public void before(JoinPoint joinPoint) throws Exception {
        Object[] args = joinPoint.getArgs();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Set constraintViolations = validator.forExecutables().validateParameters(joinPoint.getThis(), signature.getMethod(), args, new Class[0]);
        ArrayList messages = Lists.newArrayList();
        for (ConstraintViolation error : constraintViolations) {
            messages.add(error.getMessage());
        }
        if (!messages.isEmpty()) {
            throw new Exception(((Object)messages).toString());
        }
    }
}

