/*
 * Decompiled with CFR 0.152.
 */
package com.cku.thirdparty.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.PolicyConditions;
import com.cku.thirdparty.oss.OssSignatureResult;
import com.cku.thirdparty.oss.OssUploadResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.multipart.MultipartFile;

@Configuration
public class OssApiClient {
    private static final Logger log = LoggerFactory.getLogger(OssApiClient.class);
    public static final String ALI_OSS = "ali_oss";
    private static final String PATH = "/";
    public static final String HTTPS = "https://";
    @Autowired
    private OSSClient ossClient;
    @Value(value="${aliyun.oss.accessKeyId}")
    private String accessKeyId;
    @Value(value="${aliyun.oss.bucketName}")
    private String bucketName;
    @Value(value="${aliyun.oss.projectName}")
    private String projectName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OssUploadResult upload(MultipartFile file, String module) {
        InputStream is = null;
        try {
            OssUploadResult result;
            is = file.getInputStream();
            String originalName = file.getOriginalFilename();
            OssUploadResult ossUploadResult = result = this.upload(is, module, originalName);
            return ossUploadResult;
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        finally {
            if (Objects.nonNull(is)) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OssUploadResult upload(String fileDir, String module, boolean delFile) {
        FileInputStream fis = null;
        try {
            File file = new File(fileDir);
            fis = new FileInputStream(file);
            OssUploadResult result = this.upload(fis, module, file.getName());
            if (delFile && file.exists()) {
                file.delete();
            }
            OssUploadResult ossUploadResult = result;
            return ossUploadResult;
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            if (Objects.nonNull(fis)) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadCover(String fileDir, String objectPath, String objectName, boolean delFile) {
        FileInputStream fis = null;
        try {
            File file = new File(fileDir);
            fis = new FileInputStream(file);
            this.ossClient.putObject(this.bucketName, objectPath + PATH + objectName, (InputStream)fis);
            if (delFile && file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            if (Objects.nonNull(fis)) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public OssUploadResult upload(InputStream is, String module, String originalName) {
        log.info("================\u4e0a\u4f20OSS\u5f00\u59cb===================");
        if (!this.ossClient.doesBucketExist(this.bucketName)) {
            log.info("================" + this.bucketName + "\u4e0d\u5b58\u5728\uff0c\u521b\u5efaBucket===================");
            this.ossClient.createBucket(this.bucketName);
            this.ossClient.setBucketAcl(this.bucketName, CannedAccessControlList.PublicRead);
        }
        String filePath = this.getExtensionPath(module);
        String newFileName = UUID.randomUUID().toString().replaceAll("-", "") + this.getExtension(originalName);
        this.ossClient.putObject(this.bucketName, filePath + PATH + newFileName, is);
        String uploadUrl = this.getOssUrl(filePath, newFileName);
        log.info("================\u4e0a\u4f20OSS\u7ed3\u675f\uff0c\u6587\u4ef6\u5730\u5740:" + filePath + "===================");
        return OssUploadResult.builder().extensionPath(filePath).originalName(originalName).objectName(newFileName).uploadUrl(uploadUrl).build();
    }

    public OssUploadResult uploadTmp(InputStream is, String module, String originalName) {
        log.info("================\u4e0a\u4f20OSS\u5f00\u59cb===================");
        if (!this.ossClient.doesBucketExist(this.bucketName)) {
            log.info("================" + this.bucketName + "\u4e0d\u5b58\u5728\uff0c\u521b\u5efaBucket===================");
            this.ossClient.createBucket(this.bucketName);
            this.ossClient.setBucketAcl(this.bucketName, CannedAccessControlList.PublicRead);
        }
        String filePath = this.getExtensionPath(module);
        this.ossClient.putObject(this.bucketName, filePath + PATH + originalName, is);
        String uploadUrl = this.getOssUrl(filePath, originalName);
        log.info("================\u4e0a\u4f20OSS\u7ed3\u675f\uff0c\u6587\u4ef6\u5730\u5740:" + filePath + "===================");
        return OssUploadResult.builder().extensionPath(filePath).originalName(originalName).objectName(originalName).uploadUrl(uploadUrl).build();
    }

    private String getExtensionPath(String module) {
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        String path = this.projectName + PATH + module + PATH + calendar.get(1) + PATH + (calendar.get(2) + 1);
        return path;
    }

    public void fileDownload(String objectPath, String objectName, String filePath) {
        try {
            this.ossClient.getObject(new GetObjectRequest(this.bucketName, objectPath + PATH + objectName), new File(filePath));
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDownload(String objectPath, String objectName, OutputStream out) {
        OSSObject ossObject = null;
        try {
            log.info("======aliyun.oss.bucketName======" + this.bucketName);
            ossObject = this.ossClient.getObject(this.bucketName, objectPath + PATH + objectName);
            InputStream is = ossObject.getObjectContent();
            byte[] b = new byte[0x100000];
            int read = is.read(b);
            while (read != -1) {
                out.write(b, 0, read);
                read = is.read(b);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            if (Objects.nonNull(ossObject)) {
                try {
                    ossObject.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void fileDelete(String objectPath, String objectName) {
        this.ossClient.deleteObject(this.bucketName, objectPath + PATH + objectName);
    }

    public String getOssUrl(String objectPath, String objectName) {
        return HTTPS + this.bucketName + "." + this.ossClient.getEndpoint().getHost() + PATH + objectPath + PATH + objectName;
    }

    public String getExtension(String originalName) {
        int sepInd;
        char ch;
        int len;
        if (Objects.isNull(originalName) || (len = originalName.length()) == 0 || (ch = originalName.charAt(len - 1)) == '/' || ch == '\\' || ch == '.') {
            return "";
        }
        int dotInd = originalName.lastIndexOf(46);
        if (dotInd <= (sepInd = Math.max(originalName.lastIndexOf(47), originalName.lastIndexOf(92)))) {
            return "";
        }
        return originalName.substring(dotInd).toLowerCase();
    }

    public OssSignatureResult getSignature(String module, String fileName) {
        try {
            long expireTime = 30L;
            long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
            Date expiration = new Date(expireEndTime);
            String filePath = this.getExtensionPath(module);
            String newFileName = filePath + PATH + UUID.randomUUID().toString().replaceAll("-", "") + this.getExtension(fileName);
            PolicyConditions policyConds = new PolicyConditions();
            policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
            policyConds.addConditionItem(MatchMode.StartWith, "key", newFileName);
            String postPolicy = this.ossClient.generatePostPolicy(expiration, policyConds);
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = this.ossClient.calculatePostSignature(postPolicy);
            return OssSignatureResult.builder().accessid(this.accessKeyId).policy(encodedPolicy).signature(postSignature).dir(newFileName).host(HTTPS + this.bucketName + "." + this.ossClient.getEndpoint().getHost()).expire(String.valueOf(expireEndTime / 1000L)).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

