//商品详细
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //商品
        me.shopGood = ko.observable({});
        //详细
        me.showDetails = ko.observable("");
        //购买商品数量
        me.goodsNum = ko.observable("1");
        me.beiNum = ko.observable("1");

        me.showImage = ko.observable("");
        //商城购物车
        me.shopGoodList = ko.observableArray([]);
        me.shopNum = ko.observable("0");
        me.shopTotalPrice = ko.observable("0");
        //优惠
        me.discount = ko.observable("");
        //图片数量
        me.ImageCount = ko.observable(0);
        me.ImageChangeFlag = ko.observable(false);
        me.getDetail = function(id){
            util.sendAjax({
                url:'shop/shopGoods/'+id,
                data:{},
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        var shopGoods = json.data;
                        var list  = shopGoods.imageList;
                        me.ImageCount(list.length);
                        if(list.length>4){
                            me.ImageChangeFlag(true);
                        }
                        if(list.length>0){
                            for(var i=0;i<list.length;i++){
                                list[i] = "/oa-web/api/v1/file/image/"+list[i];
                            }
                            me.showImage(list[0]);
                            shopGoods.imageList = list;
                        }else{
                            me.showImage("images/default.png");
                        }
                        var arr = [];
                        if(shopGoods.buyGifts!=""){
                            arr.push(shopGoods.buyGifts);
                        }
                        if(shopGoods.isRebate=="1"){
                            arr.push("返利")
                        }
                        if(shopGoods.isFreight=="0"){
                            arr.push("免运费")
                        }
                        if(shopGoods.isInterval=="1"){
                            if(shopGoods.interval1Num == shopGoods.interval2Num){
                                arr.push(" 0-"+shopGoods.interval1Num+"价格为"+shopGoods.interval1Price+" "+shopGoods.interval1Num+"-&"+shopGoods.interval2Price);
                            }else{
                                arr.push(" 0-"+shopGoods.interval1Num+"价格为"+shopGoods.interval1Price+" "+shopGoods.interval1Num+"-"+shopGoods.interval2Num+"价格为"+shopGoods.interval2Price+" "+shopGoods.interval2Num+"-&价格为"+shopGoods.interval3Price);
                            }

                        }
                        me.discount(arr.join(","));
                        if(shopGoods.buyGifts=="满5返1,满10返3"){
                            me.beiNum("5");
                        }else if(shopGoods.buyGifts=="满10返2"){
                            me.beiNum("10");
                        }else{
                            me.beiNum("1");
                        }
                        me.goodsNum(me.beiNum());
                        me.shopGood(shopGoods);
                        me.showDetails(me.html_decode(me.shopGood().details));
                    }
                }
            });
        }

        me.changeShowImage = function(data){
            me.showImage(data);
        }
        me.preChangeImageList = function(){
                $("#imageListUl li:lt(4)").css("display","block");

        }
        me.nextChangeImageList = function(){
                $("#imageListUl li:lt(4)").css("display","none");
        }
        /**
         * 转义
         * @param str
         * @returns {*}
         */
        me.html_decode = function(str){
            var s = str;
            if (str.length == 0) return "";
            s = s.replace(/&lt;/g, "<");
            s = s.replace(/&gt;/g, ">");
            s = s.replace(/&nbsp;/g, " ");
            s = s.replace(/&#39;/g, "\'");
            s = s.replace(/&quot;/g, "\"");
            return s;
        }
        /**
         * 添加
         */
        me.upNum = function(){
           var goodsNum = me.goodsNum();
            me.goodsNum((parseInt(goodsNum)+parseInt(me.beiNum()))+"");
        }
        /**
         * 减少
         */
        me.downNum = function(){
            var goodsNum = me.goodsNum();
            if(parseInt(goodsNum)<=parseInt(me.beiNum())){
                me.goodsNum(me.beiNum());
            }else{
                me.goodsNum((parseInt(goodsNum)-parseInt(me.beiNum()))+"");
            }
        }
        me.addCarts = function(){
            //买5返1，买10返3
            if(me.shopGood().buyGifts=="满5返1,满10返3"){
                util.sendAjax({
                    url:'shop/shopGoods/getBuyGifts',
                    data:{id:me.shopGood().id},
                    async:false,
                    type:'GET',
                    cache:false,
                    success:function(json){
                        var html="";
                        $.each(json.list,function(index,item){
                            html+="<option value=\""+item.id+"\">"+item.name+"</option>";
                        });
                        layer.open({
                            type: 1,
                            title:'选择赠品',
                            area: ['420px', '240px'], //宽高
                            closeBtn: 0, //不显示关闭按钮
                            shift: 2,
                            shadeClose: true, //开启遮罩关闭
                            content: '<div style="padding:40px 0 10px"><span style="display:inline-block;line-height:40px;padding-left:10px;float:left;">赠品：</span><div class="form-f" style="margin-left:60px;"><select name="" id="buyGiftsId" style="height:40px;line-height:40px;>'+html+'</select></div>',
                            btn: ['确定', '关闭'],
                            yes:function(index, layero){
                                var buyGiftsGoods = $("#buyGiftsId").val();
                                layer.close(index);
                                if(util.isVal(buyGiftsGoods)==""){
                                    layer.msg("请选择买赠商品");
                                }else{
                                    me.sendAddCarts(1,buyGiftsGoods);
                                }
                            }
                        });
                    }
                });
            }
            //买10返2
            if(me.shopGood().buyGifts=="满10返2"){
                util.sendAjax({
                    url:'shop/shopGoods/getBuyGifts',
                    data:{id:me.shopGood().id},
                    async:false,
                    type:'GET',
                    cache:false,
                    success:function(json){
                        var html="";
                        $.each(json.list,function(index,item){
                            html+="<option value=\""+item.id+"\">"+item.name+"</option>";
                        });
                        layer.open({
                            type: 1,
                            title:'选择赠品',
                            area: ['420px', '240px'], //宽高
                            closeBtn: 0, //不显示关闭按钮
                            shift: 2,
                            shadeClose: true, //开启遮罩关闭
                            content: '<div style="padding:40px 0 10px"><span style="display:inline-block;line-height:40px;padding-left:10px;float:left;">赠品：</span><div class="form-f" style="margin-left:60px;"><select name="" id="buyGiftsId" style="height:40px;line-height:40px;>'+html+'</select></div>',
                            btn: ['确定', '关闭'],
                            yes:function(index, layero){
                                var buyGiftsGoods = $("#buyGiftsId").val();
                                layer.close(index);
                                if(util.isVal(buyGiftsGoods)==""){
                                    layer.msg("请选择买赠商品");
                                }else{
                                    me.sendAddCarts(2,buyGiftsGoods);
                                }
                            }
                        });
                    }
                });
            }
            if(me.shopGood().buyGifts==""){
                me.sendAddCarts(0,null);
            }
        }
        /**
         * 添加购物车
         */
        me.sendAddCarts = function(type,buyGiftsGoods){
            var sendData = {};
            sendData["goodsId"] = me.shopGood().id ;
            sendData["goodsNum"] = me.goodsNum();
            if(type==0){
                sendData["buyGiftsGoods"] = "";
            }else{
                sendData["buyGiftsGoods"] = buyGiftsGoods;
            }
            util.sendAjax({
                url:'shop/shopCarts',
                data:JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        layer.msg("加入购物车成功！");
                        context.app.changeShopCart();
                        me.shopGoodList(context.app.shopGoodList());
                        me.shopNum(context.app.shopNum());
                        me.shopTotalPrice(context.app.shopTotalPrice());
                    }else{
                        layer.msg("添加购物车失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }
        /**
         * 展现购物车
         */
        me.showCarts = function(){
            if($("#cartsDiv").css("display")=="none"){
                $("#cartsDiv").css("display","block");
            }else{
                $("#cartsDiv").css("display","none");
            }
        }
        $(function(){
            var obj = util.getQueryString();
            me.getDetail(obj.id);
            me.shopGoodList(context.app.shopGoodList());
            me.shopNum(context.app.shopNum());
            me.shopTotalPrice(context.app.shopTotalPrice());
        })
        //什么都没干，就是个演示
        context.app.loading(false);
        context.app.isShop(true);
    }
});